/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.ss.ttm.player.EGLSurfaceTexture;

@TargetApi(value=17)
public final class DummySurface
extends Surface {
    private static final String TAG = "DummySurface";
    private static final String EXTENSION_PROTECTED_CONTENT = "EGL_EXT_protected_content";
    private static final String EXTENSION_SURFACELESS_CONTEXT = "EGL_KHR_surfaceless_context";
    public final boolean secure;
    private static int secureMode;
    private static boolean secureModeInitialized;
    private final DummySurfaceThread thread;
    private boolean threadReleased;

    public static synchronized boolean isSecureSupported(Context context) {
        if (!secureModeInitialized) {
            secureMode = Build.VERSION.SDK_INT < 24 ? 0 : DummySurface.getSecureModeV24(context);
            secureModeInitialized = true;
        }
        return secureMode != 0;
    }

    public static DummySurface newInstanceV17(boolean secure) {
        DummySurface.assertApiLevel17OrHigher();
        DummySurfaceThread thread = new DummySurfaceThread();
        return thread.init(secure ? secureMode : 0);
    }

    private DummySurface(DummySurfaceThread thread, SurfaceTexture surfaceTexture, boolean secure) {
        super(surfaceTexture);
        this.thread = thread;
        this.secure = secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        super.release();
        DummySurfaceThread dummySurfaceThread = this.thread;
        synchronized (dummySurfaceThread) {
            if (!this.threadReleased) {
                this.thread.release();
                this.threadReleased = true;
            }
        }
    }

    private static void assertApiLevel17OrHigher() {
        if (Build.VERSION.SDK_INT < 17) {
            throw new UnsupportedOperationException("Unsupported prior to API level 17");
        }
    }

    @TargetApi(value=24)
    private static int getSecureModeV24(Context context) {
        if (Build.VERSION.SDK_INT < 26 && ("samsung".equals(Build.MANUFACTURER) || "XT1650".equals(Build.MODEL))) {
            return 0;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        if (eglExtensions == null) {
            return 0;
        }
        if (!eglExtensions.contains(EXTENSION_PROTECTED_CONTENT)) {
            return 0;
        }
        return eglExtensions.contains(EXTENSION_SURFACELESS_CONTEXT) ? 1 : 2;
    }

    private static class DummySurfaceThread
    extends HandlerThread
    implements Handler.Callback {
        private static final int MSG_INIT = 1;
        private static final int MSG_RELEASE = 2;
        @NonNull
        private EGLSurfaceTexture eglSurfaceTexture;
        @NonNull
        private Handler handler;
        @Nullable
        private Error initError;
        @Nullable
        private RuntimeException initException;
        @Nullable
        private DummySurface surface;

        public DummySurfaceThread() {
            super("dummySurface");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DummySurface init(int secureMode) {
            this.start();
            this.handler = new Handler(this.getLooper(), (Handler.Callback)this);
            this.eglSurfaceTexture = new EGLSurfaceTexture(this.handler);
            boolean wasInterrupted = false;
            DummySurfaceThread dummySurfaceThread = this;
            synchronized (dummySurfaceThread) {
                this.handler.obtainMessage(1, secureMode, 0).sendToTarget();
                while (this.surface == null && this.initException == null && this.initError == null) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.initException != null) {
                throw this.initException;
            }
            if (this.initError != null) {
                throw this.initError;
            }
            if (this.surface == null) {
                throw new NullPointerException();
            }
            return this.surface;
        }

        public void release() {
            if (this.handler == null) {
                throw new NullPointerException();
            }
            this.handler.sendEmptyMessage(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    try {
                        this.initInternal(msg.arg1);
                    }
                    catch (RuntimeException e) {
                        Log.e((String)DummySurface.TAG, (String)"Failed to initialize dummy surface", (Throwable)e);
                        this.initException = e;
                    }
                    catch (Error e) {
                        Log.e((String)DummySurface.TAG, (String)"Failed to initialize dummy surface", (Throwable)e);
                        this.initError = e;
                    }
                    finally {
                        DummySurfaceThread e = this;
                        synchronized (e) {
                            ((Object)((Object)this)).notify();
                        }
                    }
                    return true;
                }
                case 2: {
                    try {
                        this.releaseInternal();
                    }
                    catch (Throwable e) {
                        Log.e((String)DummySurface.TAG, (String)"Failed to release dummy surface", (Throwable)e);
                    }
                    finally {
                        this.quit();
                    }
                    return true;
                }
            }
            return true;
        }

        private void initInternal(int secureMode) {
            if (this.eglSurfaceTexture == null) {
                throw new NullPointerException();
            }
            this.eglSurfaceTexture.init(secureMode);
            this.surface = new DummySurface(this, this.eglSurfaceTexture.getSurfaceTexture(), secureMode != 0);
        }

        private void releaseInternal() {
            if (this.eglSurfaceTexture == null) {
                throw new NullPointerException();
            }
            this.eglSurfaceTexture.release();
        }
    }
}

