/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    private static final Pattern PROFILE_PATTERN = Pattern.compile("^\\D?(\\d+)$");
    private static final Map<String, Integer> DOLBY_VISION_STRING_TO_PROFILE;
    private static final Map<String, Integer> DOLBY_VISION_STRING_TO_LEVEL;

    @Nullable
    public static Pair<Integer, Integer> getDolbyVisionProfileAndLevel(String codec, String[] parts) {
        if (parts.length < 3) {
            Log.w((String)TAG, (String)("Ignoring malformed Dolby Vision codec string: " + codec));
            return null;
        }
        Matcher matcher = PROFILE_PATTERN.matcher(parts[1]);
        if (!matcher.matches()) {
            Log.w((String)TAG, (String)("Ignoring malformed Dolby Vision codec string: " + codec));
            return null;
        }
        String profileString = matcher.group(1);
        Integer profile = DOLBY_VISION_STRING_TO_PROFILE.get(profileString);
        if (profile == null) {
            Log.w((String)TAG, (String)("Unknown Dolby Vision profile string: " + profileString));
            return null;
        }
        String levelString = parts[2];
        Integer level = DOLBY_VISION_STRING_TO_LEVEL.get(levelString);
        if (level == null) {
            Log.w((String)TAG, (String)("Unknown Dolby Vision level string: " + levelString));
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    @Nullable
    public static String getDolbyCodecs(int dvProfile, int dvLevel) {
        String codecsPrefix;
        if (dvProfile == 4 || dvProfile == 5 || dvProfile == 7) {
            codecsPrefix = "dvhe";
        } else if (dvProfile == 8) {
            codecsPrefix = "hev1";
        } else if (dvProfile == 9) {
            codecsPrefix = "avc3";
        } else {
            return null;
        }
        String codecs = codecsPrefix + ".0" + dvProfile + ".0" + dvLevel;
        return codecs;
    }

    static {
        DOLBY_VISION_STRING_TO_LEVEL = new HashMap<String, Integer>();
        DOLBY_VISION_STRING_TO_LEVEL.put("01", 1);
        DOLBY_VISION_STRING_TO_LEVEL.put("02", 2);
        DOLBY_VISION_STRING_TO_LEVEL.put("03", 4);
        DOLBY_VISION_STRING_TO_LEVEL.put("04", 8);
        DOLBY_VISION_STRING_TO_LEVEL.put("05", 16);
        DOLBY_VISION_STRING_TO_LEVEL.put("06", 32);
        DOLBY_VISION_STRING_TO_LEVEL.put("07", 64);
        DOLBY_VISION_STRING_TO_LEVEL.put("08", 128);
        DOLBY_VISION_STRING_TO_LEVEL.put("09", 256);
        DOLBY_VISION_STRING_TO_PROFILE = new HashMap<String, Integer>();
        DOLBY_VISION_STRING_TO_PROFILE.put("00", 1);
        DOLBY_VISION_STRING_TO_PROFILE.put("01", 2);
        DOLBY_VISION_STRING_TO_PROFILE.put("02", 4);
        DOLBY_VISION_STRING_TO_PROFILE.put("03", 8);
        DOLBY_VISION_STRING_TO_PROFILE.put("04", 16);
        DOLBY_VISION_STRING_TO_PROFILE.put("05", 32);
        DOLBY_VISION_STRING_TO_PROFILE.put("06", 64);
        DOLBY_VISION_STRING_TO_PROFILE.put("07", 128);
        DOLBY_VISION_STRING_TO_PROFILE.put("08", 256);
        DOLBY_VISION_STRING_TO_PROFILE.put("09", 512);
    }
}

