/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class MediaFormat {
    private Map<String, Object> mMap;
    public static final String KEY_AUDIO = "audio";
    public static final String KEY_VIDEO = "video";
    public static final String KEY_SUBTITLE = "subtitle";
    public static final String KEY_TRACK_ID = "track-id";
    public static final String KEY_WIDTH = "width";
    public static final String KEY_HEIGHT = "height";
    public static final String KEY_BIT_RATE = "bitrate";
    public static final String KEY_SAMPLE_RATE = "sample-rate";
    public static final String KEY_CHANNEL_COUNT = "channel-count";
    public static final String KEY_LANGUAGE = "language";

    public MediaFormat() {
        this.mMap = new HashMap<String, Object>();
    }

    public MediaFormat(Map<String, Object> values) {
        this.mMap = values;
    }

    public Map<String, Object> getValues() {
        return this.mMap;
    }

    public final int getInteger(String name) {
        return (Integer)this.mMap.get(name);
    }

    public final long getLong(String name) {
        return (Long)this.mMap.get(name);
    }

    public final float getFloat(String name) {
        return ((Float)this.mMap.get(name)).floatValue();
    }

    public final String getString(String name) {
        return (String)this.mMap.get(name);
    }

    public final void setInteger(String name, int value) {
        this.mMap.put(name, value);
    }

    public final void setLong(String name, long value) {
        this.mMap.put(name, value);
    }

    public final void setFloat(String name, float value) {
        this.mMap.put(name, Float.valueOf(value));
    }

    public final void setString(String name, String value) {
        this.mMap.put(name, value);
    }

    public static final MediaFormat createAudioFormat(int trackId, int sampleRate, int channelCount) {
        MediaFormat format = new MediaFormat();
        format.setInteger(KEY_TRACK_ID, trackId);
        format.setInteger(KEY_SAMPLE_RATE, sampleRate);
        format.setInteger(KEY_CHANNEL_COUNT, channelCount);
        return format;
    }

    public static final MediaFormat createSubtitleFormat(int trackId, String language) {
        MediaFormat format = new MediaFormat();
        format.setInteger(KEY_TRACK_ID, trackId);
        format.setString(KEY_LANGUAGE, language);
        return format;
    }

    public static final MediaFormat createVideoFormat(int trackId, int width, int height, int bitrate) {
        MediaFormat format = new MediaFormat();
        format.setInteger(KEY_TRACK_ID, trackId);
        format.setInteger(KEY_WIDTH, width);
        format.setInteger(KEY_HEIGHT, height);
        format.setInteger(KEY_BIT_RATE, bitrate);
        return format;
    }

    public static final MediaFormat createAudioFormat(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        return MediaFormat.createAudioFormat(obj.optInt(KEY_TRACK_ID), obj.optInt(KEY_SAMPLE_RATE), obj.optInt(KEY_CHANNEL_COUNT));
    }

    public static final MediaFormat createSubtitleFormat(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        return MediaFormat.createSubtitleFormat(obj.optInt(KEY_TRACK_ID), obj.optString(KEY_LANGUAGE));
    }

    public static final MediaFormat createVideoFormat(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        return MediaFormat.createVideoFormat(obj.optInt(KEY_TRACK_ID), obj.optInt(KEY_WIDTH), obj.optInt(KEY_HEIGHT), obj.optInt(KEY_BIT_RATE));
    }

    public static final MediaFormat createAudioFormat(android.media.MediaFormat format) {
        if (format == null) {
            return null;
        }
        return MediaFormat.createAudioFormat(format.getInteger(KEY_TRACK_ID), format.getInteger(KEY_SAMPLE_RATE), format.getInteger(KEY_CHANNEL_COUNT));
    }

    public static final MediaFormat createSubtitleFormat(android.media.MediaFormat format) {
        if (format == null) {
            return null;
        }
        return MediaFormat.createSubtitleFormat(format.getInteger(KEY_TRACK_ID), format.getString(KEY_LANGUAGE));
    }

    public static final MediaFormat createVideoFormat(android.media.MediaFormat format) {
        if (format == null) {
            return null;
        }
        return MediaFormat.createVideoFormat(format.getInteger(KEY_TRACK_ID), format.getInteger(KEY_WIDTH), format.getInteger(KEY_HEIGHT), format.getInteger(KEY_BIT_RATE));
    }

    public String toString() {
        return this.mMap.toString();
    }
}

