/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.ss.ttm.player.FrameMetadataListener;
import com.ss.ttm.player.IMediaDataSource;
import com.ss.ttm.player.LoadControl;
import com.ss.ttm.player.MaskInfo;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttm.player.MediaPlayerClient;
import com.ss.ttm.player.MediaTransport;
import com.ss.ttm.player.PlaybackParams;
import com.ss.ttm.player.SubInfo;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;

public class OSPlayerClient
extends MediaPlayerClient {
    private android.media.MediaPlayer mPlayer;
    private MediaPlayer mWrapper;
    protected MediaPlayer.OnInfoListener mOnInfoListener;
    protected MediaPlayer.OnErrorListener mOnErrorListener;
    protected MediaPlayer.OnPreparedListener mOnPreparedListener;
    protected MediaPlayer.OnCompletionListener mOnCompletionListener;
    protected MediaPlayer.OnSeekCompleteListener mOnSeekCompleteListener;
    protected MediaPlayer.OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    protected MediaPlayer.OnBufferingUpdateListener mOnBufferingUpdateListener;

    public static final synchronized OSPlayerClient create(MediaPlayer wrapper, Context context) {
        OSPlayerClient player = new OSPlayerClient();
        player.mPlayer = new android.media.MediaPlayer();
        player.mWrapper = wrapper;
        return player;
    }

    @Override
    public void release() {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.release();
            }
            catch (Exception exception) {
            }
            finally {
                this.mPlayer = null;
            }
        }
    }

    @Override
    public void prevClose() {
    }

    @Override
    public void start() {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void pause() {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.pause();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void reset() {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void prepare() {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.prepare();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void prepareAsync() {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.prepareAsync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int getCurrentPosition() {
        if (this.mPlayer != null) {
            int position = 0;
            try {
                position = this.mPlayer.getCurrentPosition();
                return position;
            }
            catch (Exception exception) {}
            finally {
                return position;
            }
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.mPlayer != null) {
            int height = 0;
            try {
                height = this.mPlayer.getVideoHeight();
                return height;
            }
            catch (Exception exception) {}
            finally {
                return height;
            }
        }
        return 0;
    }

    @Override
    public int getVideoWidth() {
        if (this.mPlayer != null) {
            int width = 0;
            try {
                width = this.mPlayer.getVideoWidth();
                return width;
            }
            catch (Exception exception) {}
            finally {
                return width;
            }
        }
        return 0;
    }

    @Override
    public int getDuration() {
        if (this.mPlayer != null) {
            int duration = 0;
            try {
                duration = this.mPlayer.getDuration();
                return duration;
            }
            catch (Exception exception) {}
            finally {
                return duration;
            }
        }
        return 0;
    }

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        if (this.mPlayer == null) {
            return;
        }
        try {
            this.mPlayer.setDisplay(surfaceHolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mPlayer != null) {
            boolean isPlaying = false;
            try {
                isPlaying = this.mPlayer.isPlaying();
                return isPlaying;
            }
            catch (Exception exception) {}
            finally {
                return isPlaying;
            }
        }
        return false;
    }

    @Override
    public boolean isLooping() {
        if (this.mPlayer != null) {
            boolean isLooping = false;
            try {
                isLooping = this.mPlayer.isLooping();
                return isLooping;
            }
            catch (Exception exception) {}
            finally {
                return isLooping;
            }
        }
        return false;
    }

    @Override
    public void setLooping(boolean b) {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.setLooping(b);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setVolume(float left, float right) {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.setVolume(left, right);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void seekTo(int msec) {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.seekTo(msec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mPlayer != null) {
            try {
                this.mPlayer.setScreenOnWhilePlaying(screenOn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
        this.mPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)new WrapOnBufferingUpdateListener(listener, this.mWrapper));
    }

    @Override
    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
        this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)new WrapOnCompletionListener(listener, this.mWrapper));
    }

    @Override
    public void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        this.mOnErrorListener = listener;
        this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)new WrapOnErrorListener(listener, this.mWrapper));
    }

    @Override
    public void setOnInfoListener(MediaPlayer.OnInfoListener listener) {
        this.mOnInfoListener = listener;
        this.mPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)new WrapOnInfoListener(listener, this.mWrapper));
    }

    @Override
    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
        this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)new WrapOnPreparedListener(listener, this.mWrapper));
    }

    @Override
    public void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
        this.mPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)new WrapOnSeekCompleteListener(listener, this.mWrapper));
    }

    @Override
    public void setOnExternInfoListener(MediaPlayer.OnExternInfoListener listener) {
    }

    @Override
    public void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener listener) {
        this.mPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)new WrapOnVideoSizeChangedListener(listener, this.mWrapper));
    }

    @Override
    public void setOnSARChangedListener(MediaPlayer.onSARChangedListener listener) {
    }

    @Override
    public void setMediaTransport(MediaTransport transport) {
    }

    public void setLoadControl(LoadControl control) {
    }

    public void setMaskInfo(MaskInfo maskInfo) {
    }

    public void setSubInfo(SubInfo subInfo) {
    }

    @Override
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        this.mPlayer.setDataSource(context, uri, headers);
    }

    @Override
    public void setDataSource(String path) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        this.mPlayer.setDataSource(path);
    }

    @Override
    public void setDataSource(FileDescriptor fd, long offset, long length) throws IllegalStateException, IllegalArgumentException, IOException {
        this.mPlayer.setDataSource(fd, offset, length);
    }

    @Override
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        this.mPlayer.setDataSource(context, uri);
    }

    @Override
    public void setDataSource(IMediaDataSource dataSource) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
    }

    @Override
    public void setSurface(Surface surface) {
        this.mPlayer.setSurface(surface);
    }

    @Override
    public void setWakeMode(Context context, int mode) {
        this.mPlayer.setWakeMode(context, mode);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void takeScreenshot(MediaPlayer.OnScreenshotListener listener) {
    }

    @Override
    public void switchStream(int bitrate, int streamType) {
    }

    @Override
    public void releaseAsync() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OSPlayerClient.this.release();
            }
        }).start();
    }

    @Override
    public void setPlaybackParams(PlaybackParams params) {
        if (Build.VERSION.SDK_INT >= 23) {
            float pitch;
            int afm;
            android.media.PlaybackParams aparams = new android.media.PlaybackParams();
            float speed = params.getSpeed();
            if (speed > 0.0f) {
                aparams.setSpeed(speed);
            }
            if ((afm = params.getAudioFallbackMode()) >= 0) {
                aparams.setAudioFallbackMode(afm);
            }
            if ((pitch = params.getPitch()) > 0.0f) {
                aparams.setPitch(pitch);
            }
            if (this.mPlayer != null) {
                try {
                    this.mPlayer.setPlaybackParams(aparams);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void selectTrack(int index) {
    }

    @Override
    public void deselectTrack(int index) {
        if (this.mPlayer != null) {
            try {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mPlayer.deselectTrack(index);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSelectedTrack(int trackType) {
        if (this.mPlayer != null) {
            int selectTrack = 0;
            try {
                selectTrack = this.mPlayer.getSelectedTrack(trackType);
                return selectTrack;
            }
            catch (Exception exception) {}
            finally {
                return selectTrack;
            }
        }
        return -1;
    }

    @Override
    public MediaPlayer.TrackInfo[] getTrackInfo() {
        if (this.mPlayer != null) {
            MediaPlayer.TrackInfo[] trackInfos = null;
            try {
                if (Build.VERSION.SDK_INT >= 16) {
                    trackInfos = this.mPlayer.getTrackInfo();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (trackInfos != null) {
                int i = 0;
                MediaPlayer.TrackInfo[] dst = new MediaPlayer.TrackInfo[trackInfos.length];
                for (MediaPlayer.TrackInfo trackInfo : trackInfos) {
                    dst[i++] = new MediaPlayer.TrackInfo(trackInfo);
                }
            }
        }
        return null;
    }

    @Override
    public void setFrameMetadataListener(FrameMetadataListener listener) {
    }

    private static class WrapOnVideoSizeChangedListener
    implements MediaPlayer.OnVideoSizeChangedListener {
        private MediaPlayer.OnVideoSizeChangedListener mListener;
        private MediaPlayer mWrapper;

        public WrapOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener listener, MediaPlayer player) {
            this.mListener = listener;
            this.mWrapper = player;
        }

        public void onVideoSizeChanged(android.media.MediaPlayer mp, int width, int height) {
            this.mListener.onVideoSizeChanged(this.mWrapper, width, height);
        }
    }

    private static class WrapOnSeekCompleteListener
    implements MediaPlayer.OnSeekCompleteListener {
        private MediaPlayer.OnSeekCompleteListener mListener;
        private MediaPlayer mWrapper;

        public WrapOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener listener, MediaPlayer player) {
            this.mListener = listener;
            this.mWrapper = player;
        }

        public void onSeekComplete(android.media.MediaPlayer mp) {
            this.mListener.onSeekComplete(this.mWrapper);
        }
    }

    static class WrapOnPreparedListener
    implements MediaPlayer.OnPreparedListener {
        private MediaPlayer.OnPreparedListener mListener;
        private MediaPlayer mWrapper;

        public WrapOnPreparedListener(MediaPlayer.OnPreparedListener listener, MediaPlayer wrapper) {
            this.mListener = listener;
            this.mWrapper = wrapper;
        }

        public void onPrepared(android.media.MediaPlayer mp) {
            this.mListener.onPrepared(this.mWrapper);
        }
    }

    static class WrapOnInfoListener
    implements MediaPlayer.OnInfoListener {
        private MediaPlayer.OnInfoListener mListener;
        private MediaPlayer mWrapper;

        public WrapOnInfoListener(MediaPlayer.OnInfoListener listener, MediaPlayer wrapper) {
            this.mWrapper = wrapper;
            this.mListener = listener;
        }

        public boolean onInfo(android.media.MediaPlayer mp, int what, int extra) {
            return this.mListener.onInfo(this.mWrapper, what, extra);
        }
    }

    static class WrapOnErrorListener
    implements MediaPlayer.OnErrorListener {
        private MediaPlayer.OnErrorListener mListener;
        private MediaPlayer mWrapper;

        public WrapOnErrorListener(MediaPlayer.OnErrorListener listener, MediaPlayer wrapper) {
            this.mWrapper = wrapper;
            this.mListener = listener;
        }

        public boolean onError(android.media.MediaPlayer mp, int what, int extra) {
            return this.mListener.onError(this.mWrapper, what, extra);
        }
    }

    static class WrapOnCompletionListener
    implements MediaPlayer.OnCompletionListener {
        private MediaPlayer.OnCompletionListener mListener;
        private MediaPlayer mWrapper;

        public WrapOnCompletionListener(MediaPlayer.OnCompletionListener listener, MediaPlayer wrapper) {
            this.mWrapper = wrapper;
            this.mListener = listener;
        }

        public void onCompletion(android.media.MediaPlayer mp) {
            this.mListener.onCompletion(this.mWrapper);
        }
    }

    static class WrapOnBufferingUpdateListener
    implements MediaPlayer.OnBufferingUpdateListener {
        private MediaPlayer.OnBufferingUpdateListener mListener;
        private MediaPlayer mWrapper;

        public WrapOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener, MediaPlayer wrapper) {
            this.mWrapper = wrapper;
            this.mListener = listener;
        }

        public void onBufferingUpdate(android.media.MediaPlayer mp, int percent) {
            this.mListener.onBufferingUpdate(this.mWrapper, percent);
        }
    }
}

