/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import com.ss.ttm.player.CalledByNative;
import com.ss.ttm.player.JNINamespace;
import com.ss.ttm.player.NativeObject;
import java.util.ArrayList;
import java.util.List;

@JNINamespace(value="PLAYER")
public class SidxListObject
extends NativeObject {
    private int mMediaType;
    private int mTotalNum;
    private int mStartIndex;
    private int mEndIndex;
    private long mBitrate;
    private String mFileId;
    private List<SidxItem> mItems;

    @CalledByNative
    public SidxListObject(int mediaType, int totalNum, int startIndex, int endIndex, long bitrate, String fileId) {
        this.mMediaType = mediaType;
        this.mTotalNum = totalNum;
        this.mStartIndex = startIndex;
        this.mEndIndex = endIndex;
        this.mBitrate = bitrate;
        this.mFileId = fileId;
        this.mItems = new ArrayList<SidxItem>();
    }

    @CalledByNative
    public void addItem(int index, long offset, long timestamp, long duration, long size) {
        this.mItems.add(new SidxItem(index, offset, timestamp, duration, size));
    }

    public int getMediaType() {
        return this.mMediaType;
    }

    public int getTotalNum() {
        return this.mTotalNum;
    }

    public int getStartIndex() {
        return this.mStartIndex;
    }

    public int getEndIndex() {
        return this.mEndIndex;
    }

    public long getBitrate() {
        return this.mBitrate;
    }

    public String getFileId() {
        return this.mFileId;
    }

    public SidxItem getItem(int index) {
        if (index >= 0 && index < this.mItems.size()) {
            return this.mItems.get(index);
        }
        return null;
    }

    public static class SidxItem {
        private int mIndex;
        private long mOffset;
        private long mTimestamp;
        private long mDuration;
        private long mSize;

        public SidxItem(int index, long offset, long timestamp, long duration, long size) {
            this.mIndex = index;
            this.mOffset = offset;
            this.mTimestamp = timestamp;
            this.mDuration = duration;
            this.mSize = size;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public long getOffset() {
            return this.mOffset;
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }

        public long getDuration() {
            return this.mDuration;
        }

        public long getSize() {
            return this.mSize;
        }
    }
}

