/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.ss.ttm.player.TTPlayerConfiger;
import com.ss.ttm.utils.AVTime;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;

public final class TTCrashUtil {
    public static void deleteCrashFile(Context context, String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    public static boolean existsCrashFile(Context context, String path) {
        if (context == null && path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static final String existsCrashFilePath(Context context) {
        File file;
        String path = null;
        if (TTPlayerConfiger.getValue(18, 1) == 1) {
            File file2;
            path = TTPlayerConfiger.getAppCrashFilePath(context);
            if (path != null && (file2 = new File(path)).exists()) {
                return path;
            }
            return null;
        }
        path = TTPlayerConfiger.getAppCrashFilePath2(context);
        if (path != null && (file = new File(path)).exists()) {
            return path;
        }
        path = TTPlayerConfiger.getPlugerCrashFilePath(context);
        if (path != null && (file = new File(path)).exists()) {
            return path;
        }
        path = TTPlayerConfiger.getExternalStorageDirectoryCrashFilePath(context);
        if (path != null && !(file = new File(path)).exists()) {
            path = null;
        }
        return path;
    }

    public static String getBase64SampleCrash(String simpleCrash) {
        return Base64.encodeToString((byte[])simpleCrash.getBytes(), (int)0);
    }

    public static String getCrashFileContext(Context context, String path, StringBuilder builder) {
        if (context == null && path == null) {
            builder.append("context or path is null.\r\n");
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            builder.append("file not exist.path:").append(path).append("\r\n");
            return null;
        }
        long size = file.length();
        if (size == 0L) {
            builder.append("file size is zore.").append("\r\n");
            return null;
        }
        FileInputStream fis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            fis = new FileInputStream(file);
            TTCrashUtil.compress(fis, baos);
            fis.close();
            String content = Base64.encodeToString((byte[])baos.toByteArray(), (int)0);
            baos.close();
            return content;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            builder.append("gzip file is error.error:").append(e.getMessage());
            return null;
        }
    }

    public static void compress(InputStream is, OutputStream os) throws Exception {
        int count;
        GZIPOutputStream gos = new GZIPOutputStream(os);
        byte[] data = new byte[10240];
        while ((count = is.read(data, 0, 10240)) != -1) {
            gos.write(data, 0, count);
        }
        gos.flush();
        gos.finish();
        gos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean copyFile(String destFileName, String srcFileName, boolean overlay, boolean deleteSrc) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            return false;
        }
        if (!srcFile.isFile()) {
            return false;
        }
        File destFile = new File(destFileName);
        if (destFile.exists()) {
            if (overlay) {
                new File(destFileName).delete();
            }
        } else if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            return false;
        }
        int byteread = 0;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            if (deleteSrc) {
                srcFile.delete();
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final boolean moveFile(String destFileName, String srcFileName, boolean overlay) {
        return TTCrashUtil.copyFile(destFileName, srcFileName, overlay, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveException(Throwable ex, String path) {
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        FileOutputStream fos = null;
        PrintStream ps = null;
        try {
            fos = new FileOutputStream(file);
            ps = new PrintStream(fos);
            ps.write("EXCE".getBytes());
            ex.printStackTrace(ps);
        }
        catch (Exception e) {
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLowMemoryInfo(int level, String path) {
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write("LOWM\r\nrecv low memory warring info.level:" + level);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStopInfo(String path, String info) {
        FileWriter fw = null;
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        try {
            fw = new FileWriter(file);
            fw.write("STOP recv stop info:" + info + ".time:" + AVTime.getFormatNow() + "\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendTrackInfo(String path, boolean append, String info) {
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(path, append);
            writer.write(info);
        }
        catch (Exception e) {
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addTrackInfo(long playerId, String dir, String info) {
        TTCrashUtil.appendTrackInfo(TTCrashUtil.getTrackFilePath(playerId, dir), true, info);
    }

    public static void addTrackInfo(long playerId, String dir, String info, boolean replace) {
        TTCrashUtil.appendTrackInfo(TTCrashUtil.getTrackFilePath(playerId, dir), replace, info);
    }

    public static void addDebugTrackInfo(long playerId, String dir, String info, boolean append) {
        TTCrashUtil.appendTrackInfo(TTCrashUtil.getDebugTrackFilePath(playerId, dir), append, info);
    }

    private static boolean getTrackFileInfos(File file, StringBuilder info) {
        InputStreamReader fr = null;
        try {
            int ret;
            if (!file.exists()) {
                return false;
            }
            char[] buffer = new char[1024];
            fr = new FileReader(file);
            while ((ret = fr.read(buffer)) > 0) {
                info.append(buffer, 0, ret);
                if (ret >= 1024) continue;
            }
            fr.close();
            fr = null;
        }
        catch (Throwable e) {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            info.append("track message:").append(e.getMessage()).append("\r\n");
        }
        return true;
    }

    private static boolean getTrackFileInfos(String path, StringBuilder info) {
        InputStreamReader fr = null;
        try {
            int ret;
            File file = new File(path);
            if (!file.exists()) {
                info.append("path").append(path).append(" not exists.\r\n");
                return false;
            }
            char[] buffer = new char[1024];
            fr = new FileReader(file);
            while ((ret = fr.read(buffer)) > 0) {
                info.append(buffer, 0, ret);
                if (ret >= 1024) continue;
            }
            fr.close();
            fr = null;
        }
        catch (Throwable e) {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            info.append("track message:").append(e.getMessage()).append("\r\n");
        }
        return true;
    }

    public static boolean readTrackInfos(long playerId, String dir, StringBuilder info) {
        return TTCrashUtil.getTrackFileInfos(TTCrashUtil.getTrackFilePath(playerId, dir), info);
    }

    public static boolean readDebugTrackInfos(long playerId, String dir, StringBuilder info) {
        return TTCrashUtil.getTrackFileInfos(TTCrashUtil.getDebugTrackFilePath(playerId, dir), info);
    }

    private static String getDebugTrackFilePath(long playerId, String dir) {
        return String.format(Locale.US, "%s/ttplayer_logs/%d_d.log", dir, playerId);
    }

    public static String getTrackFilePath(long playerId, String dir) {
        return String.format(Locale.US, "%s/ttplayer_logs/%d.log", dir, playerId);
    }

    private static void deleteTrackFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void deleteDebugTrackFile(long playerId, String dir) {
        TTCrashUtil.deleteTrackFile(TTCrashUtil.getDebugTrackFilePath(playerId, dir));
    }

    public static void deleteTrackFile(long playerId, String dir) {
        TTCrashUtil.deleteTrackFile(TTCrashUtil.getTrackFilePath(playerId, dir));
    }

    public static boolean existsTrackFile(long playerId, String dir) {
        File file = new File(TTCrashUtil.getTrackFilePath(playerId, dir));
        return file.exists();
    }

    public static boolean moveTrackFile(long src, long dst, String dir) {
        File file = new File(TTCrashUtil.getTrackFilePath(src, dir));
        return file.renameTo(new File(TTCrashUtil.getTrackFilePath(dst, dir)));
    }

    public static void checkTrackDir(String dir) {
        File file = new File(String.format("%s/ttplayer_logs", dir));
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public static boolean existLogsFile(long handle, String dir) {
        String pName = String.valueOf(handle);
        File file = new File(String.format("%s/ttplayer_logs", dir));
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return false;
            }
            for (File logFile : files) {
                String name = logFile.getName();
                Log.i((String)"ttmp", (String)("<TTCrashUtils,existLogsFile,375>file:" + name + ",pname:" + pName));
                if (name == null || name.startsWith(pName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean readLogsInfo(long handle, String dir, StringBuilder builder) {
        String pName = String.valueOf(handle);
        File file = new File(String.format("%s/ttplayer_logs", dir));
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return false;
            }
            for (File logFile : files) {
                String name = logFile.getName();
                if (name == null || name.startsWith(pName) || !TTCrashUtil.getTrackFileInfos(logFile, builder)) continue;
                boolean d = logFile.delete();
                if (!d) {
                    Log.d((String)"ttmp", (String)("delete file:" + logFile.getName() + "," + d));
                }
                return d;
            }
        }
        return false;
    }

    public static void checkLogDir(String dir) {
        File file = new File(String.format("%s/ttplayer_logs", dir));
        if (file.exists()) {
            if (file.isDirectory()) {
                boolean d;
                File[] files = file.listFiles();
                if (files != null) {
                    for (File logFile : files) {
                        boolean d2 = logFile.delete();
                        if (d2) continue;
                        Log.d((String)"ttmp", (String)("delete file:" + logFile.getName() + "," + d2));
                    }
                }
                if (!(d = file.delete())) {
                    Log.d((String)"ttmp", (String)("delete dir file:" + file.getName() + "," + d));
                }
            }
        } else {
            boolean m = file.mkdir();
            if (!m) {
                Log.d((String)"ttmp", (String)("mkdir:" + file.getName() + "," + m));
            }
        }
    }
}

