/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.ss.ttm.player.IMediaDataSource;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttm.player.MediaPlayerClient;
import com.ss.ttm.player.MediaTransport;
import com.ss.ttm.player.OSPlayerClient;
import com.ss.ttm.player.PlaybackParams;
import com.ss.ttm.player.TTPlayerClient;
import com.ss.ttm.player.TTPlayerConfiger;
import com.ss.ttm.player.TTVersion;
import com.ss.ttm.utils.HardWareInfo;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;

public class TTMediaPlayer
implements MediaPlayer {
    protected int mPlayerType = 0;
    protected MediaPlayerClient mClient;

    public static final synchronized TTMediaPlayer create(Context context) {
        MediaPlayerClient player;
        TTMediaPlayer mediaPlayer;
        block8: {
            mediaPlayer = new TTMediaPlayer();
            player = null;
            if (TTPlayerConfiger.isPrintInfo()) {
                Log.i((String)"ttplayer", (String)("ttplayer:" + TTPlayerConfiger.getValue(1, false) + ",ipc:" + TTPlayerConfiger.getValue(2, false) + ",crashed:" + TTPlayerConfiger.getValue(7, false) + ",cpu family" + HardWareInfo.getCpuFamily() + ",debug:" + false + ",timeout count:" + TTPlayerConfiger.getValue(10, 0) + ",forbid create os player:" + TTPlayerConfiger.getValue(11, false)));
                Log.i((String)"ttplayer", (String)("version info:" + TTPlayerConfiger.getValue(15, "not find version info")));
            }
            try {
                if (TTPlayerConfiger.isOnTTPlayer() || TTPlayerConfiger.getValue(11, false)) {
                    player = TTPlayerClient.create(mediaPlayer, context, null);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (TTPlayerConfiger.getValue(7, false)) break block8;
                TTPlayerConfiger.setValue(7, true);
            }
        }
        if (player == null) {
            if (TTPlayerConfiger.isPrintInfo()) {
                Log.i((String)"ttplayer", (String)"---------->ttplayer off<------------");
            }
            if (TTPlayerConfiger.getValue(11, false)) {
                return null;
            }
            player = OSPlayerClient.create(mediaPlayer, context);
            mediaPlayer.mPlayerType = 0;
        }
        if (player == null) {
            return null;
        }
        mediaPlayer.mClient = player;
        return mediaPlayer;
    }

    @Override
    public boolean isOSPlayer() {
        return this.mClient == null || this.mClient.getType() == 0;
    }

    @Override
    public int getPlayerType() {
        if (this.mClient != null) {
            return this.mClient.getType();
        }
        return 0;
    }

    @Override
    @Deprecated
    public void prevClose() {
        if (this.mClient != null) {
            this.mClient.prevClose();
        }
    }

    @Override
    public void release() {
        if (this.mClient != null) {
            this.mClient.release();
        }
    }

    @Override
    public void releaseAsync() {
        if (this.mClient != null) {
            this.mClient.releaseAsync();
        }
    }

    @Override
    public void start() {
        if (this.mClient != null) {
            this.mClient.start();
        }
    }

    @Override
    public void pause() {
        if (this.mClient != null) {
            this.mClient.pause();
        }
    }

    @Override
    public void reset() {
        if (this.mClient != null) {
            this.mClient.reset();
        }
    }

    @Override
    public void stop() {
        if (this.mClient != null) {
            this.mClient.stop();
        }
    }

    @Override
    public void prepare() {
        if (this.mClient != null) {
            this.mClient.prepare();
        }
    }

    @Override
    public void prepareAsync() {
        if (this.mClient != null) {
            this.mClient.prepareAsync();
        }
    }

    @Override
    public int getCurrentPosition() {
        if (this.mClient != null) {
            return this.mClient.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.mClient != null) {
            return this.mClient.getVideoHeight();
        }
        return 0;
    }

    @Override
    public int getVideoWidth() {
        if (this.mClient != null) {
            return this.mClient.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getDuration() {
        if (this.mClient != null) {
            return this.mClient.getDuration();
        }
        return 0;
    }

    @Override
    public int getVideoType() {
        if (this.mClient != null) {
            return this.mClient.getVideoType();
        }
        return 0;
    }

    @Override
    public void setPanoVideoControlModel(int model) {
        if (this.mClient != null) {
            this.mClient.setPanoVideoControlModel(model);
        }
    }

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        if (this.mClient != null) {
            this.mClient.setDisplay(surfaceHolder);
        }
    }

    @Override
    public void setSurface(Surface surface) {
        if (surface == null || !surface.isValid() || this.mClient == null) {
            return;
        }
        this.mClient.setSurface(surface);
    }

    @Override
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(context, uri, headers);
        }
    }

    @Override
    public void setDataSource(String path) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(path);
        }
    }

    @Override
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(context, uri);
        }
    }

    @Override
    public void setDataSource(FileDescriptor fd, long offset, long length) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(fd, offset, length);
        }
    }

    @Override
    public void setDataSource(IMediaDataSource dataSource) throws IllegalArgumentException, IOException {
        if (this.mClient != null) {
            this.mClient.setDataSource(dataSource);
        }
    }

    @Override
    public String getDataSource() {
        if (this.mClient != null) {
            return this.mClient.getDataSource();
        }
        return null;
    }

    @Override
    public boolean isPlaying() {
        if (this.mClient != null) {
            return this.mClient.isPlaying();
        }
        return false;
    }

    @Override
    public boolean isLooping() {
        if (this.mClient != null) {
            return this.mClient.isLooping();
        }
        return false;
    }

    @Override
    public void setLooping(boolean b) {
        if (this.mClient != null) {
            this.mClient.setLooping(b);
        }
    }

    @Override
    public void setVolume(float left, float right) {
        if (this.mClient != null) {
            this.mClient.setVolume(left, right);
        }
    }

    @Override
    public void mouseEvent(int action, int deltaX, int deltaY) {
        if (this.mClient != null) {
            this.mClient.mouseEvent(action, deltaX, deltaY);
        }
    }

    @Override
    public void seekTo(int msec) {
        if (this.mClient != null) {
            this.mClient.seekTo(msec);
        }
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mClient != null) {
            this.mClient.setScreenOnWhilePlaying(screenOn);
        }
    }

    @Override
    public void setOnLogListener(MediaPlayer.OnLogListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnLogListener(listener);
        }
    }

    @Override
    public void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnBufferingUpdateListener(listener);
        }
    }

    @Override
    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnCompletionListener(listener);
        }
    }

    @Override
    public void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnErrorListener(listener);
        }
    }

    @Override
    public void setOnInfoListener(MediaPlayer.OnInfoListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnInfoListener(listener);
        }
    }

    @Override
    public void setOnExternInfoListener(MediaPlayer.OnExternInfoListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnExternInfoListener(listener);
        }
    }

    @Override
    public void setOnSARChangedListener(MediaPlayer.onSARChangedListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnSARChangedListener(listener);
        }
    }

    @Override
    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnPreparedListener(listener);
        }
    }

    @Override
    public void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnSeekCompleteListener(listener);
        }
    }

    @Override
    public void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener listener) {
        if (this.mClient != null) {
            this.mClient.setOnVideoSizeChangedListener(listener);
        }
    }

    @Override
    public void setIntOption(int key, int value) {
        if (this.mClient != null) {
            this.mClient.setIntOption(key, value);
        }
    }

    @Override
    public void setWakeMode(Context context, int mode) {
        if (this.mClient != null) {
            this.mClient.setWakeMode(context, mode);
        }
    }

    @Override
    public void setIsMute(boolean isMute) {
        if (this.mClient != null) {
            this.mClient.setIsMute(isMute);
        }
    }

    @Override
    public boolean isMute() {
        if (this.mClient != null) {
            return this.mClient.isMute();
        }
        return false;
    }

    @Override
    public void setCacheFile(String path, int mode) {
        if (this.mClient != null) {
            this.mClient.setCacheFile(path, mode);
        }
    }

    @Override
    public void setStringOption(int key, String value) {
        if (this.mClient != null) {
            this.mClient.setStringOption(key, value);
        }
    }

    @Override
    public int getIntOption(int key, int dValue) {
        if (this.mClient != null) {
            return this.mClient.getIntOption(key, dValue);
        }
        return dValue;
    }

    @Override
    public String getStringOption(int key) {
        if (this.mClient != null) {
            return this.mClient.getStringOption(key);
        }
        return null;
    }

    @Override
    public long getLongOption(int key, long dValue) {
        if (this.mClient != null) {
            return this.mClient.getLongOption(key, dValue);
        }
        return dValue;
    }

    @Override
    public long setLongOption(int key, long value) {
        if (this.mClient != null) {
            return this.mClient.setLongOption(key, value);
        }
        return -1L;
    }

    @Override
    public float getFloatOption(int key, float dValue) {
        if (this.mClient != null) {
            return this.mClient.getFloatOption(key, dValue);
        }
        return dValue;
    }

    @Override
    public int setFloatOption(int key, float value) {
        if (this.mClient != null) {
            return this.mClient.setFloatOption(key, value);
        }
        return -1;
    }

    @Override
    public void rotateCamera(float angleX, float angleY) {
        if (this.mClient != null) {
            this.mClient.rotateCamera(angleX, angleY);
        }
    }

    @Override
    public void takeScreenshot(MediaPlayer.OnScreenshotListener listener) {
        if (this.mClient != null) {
            this.mClient.takeScreenshot(listener);
        }
    }

    @Override
    public void switchStream(int bitrate, int streamType) {
        if (this.mClient != null) {
            this.mClient.switchStream(bitrate, streamType);
        }
    }

    @Override
    public void setPlaybackParams(PlaybackParams params) {
        if (this.mClient != null) {
            this.mClient.setPlaybackParams(params);
        }
    }

    @Override
    public void selectTrack(int index) {
        if (this.mClient != null && index == 0) {
            this.mClient.setIntOption(261, 0);
        }
    }

    @Override
    public void deselectTrack(int index) {
        if (this.mClient != null && index == 0) {
            this.mClient.setIntOption(261, 1);
        } else if (this.mClient != null) {
            this.mClient.setIntOption(65, index << 8 | 0);
        }
    }

    @Override
    public int getSelectedTrack(int trackType) {
        if (this.mClient != null) {
            return this.mClient.getSelectedTrack(trackType);
        }
        return -1;
    }

    @Override
    public MediaPlayer.TrackInfo[] getTrackInfo() {
        if (this.mClient != null) {
            return this.mClient.getTrackInfo();
        }
        return null;
    }

    @Override
    public void setMediaTransport(MediaTransport transport) {
        if (this.mClient != null) {
            this.mClient.setMediaTransport(transport);
        }
    }

    public void setUnSupportSampleRates(int[] sampleRates) {
        if (this.isOSPlayer()) {
            return;
        }
        int nb = sampleRates.length;
        if (nb <= 0) {
            return;
        }
        int snb = MEDIA_PLAYER_SUPPORT_SAMPLERATES.length;
        int unSupportSampleRatesInBinary = 0;
        block0: for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < snb; ++j) {
                if (MEDIA_PLAYER_SUPPORT_SAMPLERATES[j] != sampleRates[i]) continue;
                unSupportSampleRatesInBinary |= 1 << j;
                continue block0;
            }
        }
        if (this.mClient != null) {
            this.mClient.setIntOption(111, unSupportSampleRatesInBinary);
        }
    }

    static {
        TTVersion.saveVersionInfo();
    }
}

