/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import android.view.Surface;
import com.ss.ttm.player.AudioFormats;
import com.ss.ttm.player.AudioProcessor;
import com.ss.ttm.player.CalledByNative;
import com.ss.ttm.player.FrameMetadataListener;
import com.ss.ttm.player.ILibraryLoader;
import com.ss.ttm.player.IMediaDataSource;
import com.ss.ttm.player.IPlayerNotifyer;
import com.ss.ttm.player.Keep;
import com.ss.ttm.player.LoadControl;
import com.ss.ttm.player.MaskInfo;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttm.player.MediaTransport;
import com.ss.ttm.player.SubInfo;
import com.ss.ttm.player.TTPlayerConfiger;
import com.ss.ttm.player.TTPlayerKeys;
import com.ss.ttm.player.TTPlayerLibLoader;
import java.util.List;
import java.util.Map;

@Keep
public class TTPlayer {
    private static final String TAG = TTPlayer.class.getSimpleName();
    private long mHandle;
    private long mId;
    private long mNotifyerState = Long.MAX_VALUE;
    private IPlayerNotifyer mNotifyer;
    private FrameMetadataListener mFrameMetadataListener;
    private MediaPlayer.OnScreenshotListener mScreenshotListener;
    private Context mContext;
    private static int mSupportSampleRateNB = 0;
    private static int[] mSupportSampleRates;
    private static String mAppPath;
    private static String mCrashPath;
    private static boolean mIsIPCPlayer;
    private static String mCachePath;
    private int mTracker = 0;
    private static boolean mSetLibraryLoader;
    private static ILibraryLoader mDebugLibLoader;
    @Keep
    private long mMediaDataSource;

    private static final void checkPlayerModel() {
    }

    private static void detectAudioFormat() {
        if (mSupportSampleRateNB == 0) {
            mSupportSampleRates = new int[AudioFormats.getDefaultSampleRatesNB()];
            mSupportSampleRateNB = AudioFormats.getMaxSupportedSampleRates(mSupportSampleRates);
            TTPlayer._setSupprotSampleRates(mSupportSampleRates, mSupportSampleRateNB);
        }
    }

    public final long getHandle() {
        return this.mHandle;
    }

    public static final void setTempFileDir(String path) {
        mAppPath = path;
    }

    public static final String getAppPath() {
        return mAppPath;
    }

    public static final void setCachePath(String path) {
        mCachePath = path;
    }

    public static final String getCachePath() {
        return mCachePath;
    }

    public static final void setCrashPath(String path) {
        mCrashPath = path;
    }

    @CalledByNative
    public static final String getCrashPath() {
        return mCrashPath;
    }

    public static void setIsIPPlayer(boolean isIPCPlayer) {
        mIsIPCPlayer = isIPCPlayer;
    }

    @CalledByNative
    public static boolean isIPPlayer() {
        return mIsIPCPlayer;
    }

    public static void registerPlayerInfo() {
        TTPlayer._registerPlayerInfo();
    }

    public long getNativePlayer() {
        return this.mHandle;
    }

    public TTPlayer(Context context, long id) throws Exception {
        this.mContext = context;
        this.create(id);
    }

    public Context getContext() {
        return this.mContext;
    }

    private void create(long id) throws Exception {
        this.mNotifyer = null;
        this.mHandle = this._create(this.mContext, mIsIPCPlayer ? 1 : 0, mAppPath);
        this.mId = id;
        if (this.mHandle == 0L) {
            throw new Exception("create native player is fail.");
        }
    }

    protected int prepare() {
        if (this.mHandle == 0L) {
            return -1;
        }
        return TTPlayer._prepare(this.mHandle);
    }

    public int close() {
        if (this.mHandle == 0L) {
            return -1;
        }
        TTPlayer._close(this.mHandle);
        return 0;
    }

    public int prevClose() {
        if (this.mHandle == 0L) {
            return -1;
        }
        TTPlayer._setVideoSurface(this.mHandle, null);
        return 0;
    }

    protected int start() {
        if (this.mHandle == 0L) {
            return -1;
        }
        return TTPlayer._start(this.mHandle);
    }

    protected int pause() {
        if (this.mHandle == 0L) {
            return -1;
        }
        return TTPlayer._pause(this.mHandle);
    }

    protected int reset() {
        if (this.mHandle == 0L) {
            return -1;
        }
        return TTPlayer._reset(this.mHandle);
    }

    protected int stop() {
        if (this.mHandle != 0L) {
            TTPlayer._stop(this.mHandle);
            return 0;
        }
        return -1;
    }

    protected void release() {
        this.mNotifyerState = 0L;
        if (this.mHandle != 0L) {
            TTPlayer._release(this.mHandle);
            this.mHandle = 0L;
        }
        this.mNotifyer = null;
        this.mScreenshotListener = null;
    }

    protected int setVideoSurface(Surface surface) {
        int ret = -1;
        if (this.mHandle != 0L) {
            ret = TTPlayer._setVideoSurface(this.mHandle, surface);
        }
        return ret;
    }

    public int setSurfaceValue(long surface) {
        return TTPlayer._setSurfaceValue(this.mHandle, surface);
    }

    public void setDataSource(String path) {
        if (this.mHandle != 0L) {
            TTPlayer._setDataSource(this.mHandle, path);
        }
    }

    public void setDataSourceFd(int fd) {
        if (this.mHandle != 0L) {
            TTPlayer._setDataSourceFd(this.mHandle, fd);
        }
    }

    public int getIntOption(int key, int dValue) {
        switch (key) {
            case 2: {
                return TTPlayer._getCurrentPosition(this.mHandle);
            }
            case 1: {
                return TTPlayer._getDuration(this.mHandle);
            }
            case 5: {
                return TTPlayer._isLooping(this.mHandle);
            }
            case 6: {
                return TTPlayer._isPlaying(this.mHandle);
            }
            case 3: {
                return TTPlayer._getVideoWidth(this.mHandle);
            }
            case 4: {
                return TTPlayer._getVideoHeight(this.mHandle);
            }
            case 11: {
                return TTPlayer._getIntValue(this.mHandle, key, dValue);
            }
            case 51: {
                return this.mTracker;
            }
        }
        return TTPlayer._getIntValue(this.mHandle, key, dValue);
    }

    public void setLooping(int looping) {
        TTPlayer._setLooping(this.mHandle, looping);
    }

    public void setVolume(float left, float right) {
        TTPlayer._setVolume(this.mHandle, left, right);
    }

    public void mouseEvent(int action, int deltaX, int deltaY) {
        TTPlayer._mouseEvent(this.mHandle, action, deltaX, deltaY);
    }

    public void seekTo(int msec) {
        TTPlayer._seek(this.mHandle, msec);
    }

    public void setNotifyerState(long lState) {
        this.mNotifyerState = lState;
        TTPlayer._setIntValue(this.mHandle, 16, (int)lState);
        TTPlayer._setLongValue(this.mHandle, 16, lState);
    }

    public void takeScreenshot() {
        TTPlayer._takeScreenshot(this.mHandle);
    }

    public void switchStream(int bitrate, int streamType) {
        TTPlayer._switchStream(this.mHandle, bitrate, streamType);
    }

    public void setOnScreenshotListener(MediaPlayer.OnScreenshotListener listener) {
        this.mScreenshotListener = listener;
    }

    @CalledByNative
    public final void takeScreenshotComplete(Bitmap bitmap) {
        if (this.mScreenshotListener != null) {
            this.mScreenshotListener.onTakeScreenShotCompletion(bitmap);
        }
    }

    @CalledByNative
    public void onFrameAboutToBeRendered(int type, long pts, long wallClockTime, Map<Integer, String> frameData) {
        try {
            if (this.mFrameMetadataListener != null) {
                this.mFrameMetadataListener.onFrameAboutToBeRendered(type, pts, wallClockTime, frameData);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @CalledByNative
    public void updateFrameTerminatedDTS(int streamType, long dts, long pts) {
        try {
            if (this.mFrameMetadataListener != null) {
                this.mFrameMetadataListener.updateFrameTerminatedDTS(streamType, pts, dts);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @CalledByNative
    public void frameDTSNotify(int streamType, long dts, long pts) {
        try {
            if (this.mFrameMetadataListener != null) {
                this.mFrameMetadataListener.frameDTSNotify(streamType, pts, dts);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @CalledByNative
    public void onNotify(int lifeId, int what, int parameter, String info) {
        if ((this.mNotifyerState >> what & 1L) != 1L) {
            return;
        }
        try {
            if (this.mNotifyer != null) {
                this.mNotifyer.handlePlayerNotify(this.mId, lifeId, what, parameter, info);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @CalledByNative
    public final void onLogInfo(int type, int code, String logInfo) {
        if (this.mNotifyer != null) {
            try {
                this.mNotifyer.handleErrorNotify(this.mId, type, code, logInfo);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setNotifyer(IPlayerNotifyer notifyer) {
        this.mNotifyer = notifyer;
    }

    public void setFrameMetadataListener(FrameMetadataListener listener) {
        this.mFrameMetadataListener = listener;
    }

    public int setIntOption(int key, int value) throws RemoteException {
        if (key == 22) {
            if (value == 0) {
                Log.i((String)"ttplayer", (String)"will occur anr crash");
            } else if (value == 2) {
                Log.i((String)"ttplayer", (String)"will occur native crash");
            } else if (value == 1) {
                Process.killProcess((int)Process.myPid());
                System.exit(0);
                String jcrash = null;
                Log.i((String)"ttplayer", (String)"will occur java crash");
                if (jcrash.endsWith("java")) {
                    throw new RemoteException("simple crash occur");
                }
                Log.i((String)"ttplayer", (String)"occur java crash end");
            }
        }
        if (key == 111) {
            int nb = TTPlayerKeys.SupportSampleRates.length;
            int[] tmpSupportSampleRates = new int[TTPlayerKeys.SupportSampleRates.length];
            int newnb = 0;
            for (int i = 0; i < nb; ++i) {
                if ((value & 1 << i) != 0) continue;
                tmpSupportSampleRates[newnb] = TTPlayerKeys.SupportSampleRates[i];
                ++newnb;
            }
            TTPlayer._setSupprotSampleRates(tmpSupportSampleRates, newnb);
            return 0;
        }
        return TTPlayer._setIntValue(this.mHandle, key, value);
    }

    public void setDataSource(IMediaDataSource mediaDataSource) throws IllegalArgumentException, SecurityException, IllegalStateException {
        if (this.mHandle != 0L) {
            TTPlayer._setDataSource(this.mHandle, mediaDataSource);
        }
    }

    public void setLoadControl(LoadControl loadControl) {
        if (this.mHandle != 0L) {
            TTPlayer._setLoadControl(this.mHandle, loadControl);
        }
    }

    public void setMaskInfo(MaskInfo maskInfo) {
        if (this.mHandle != 0L) {
            TTPlayer._setMaskInfo(this.mHandle, maskInfo);
        }
    }

    public void setSubInfo(SubInfo subInfo) {
        if (this.mHandle != 0L) {
            TTPlayer._setSubInfo(this.mHandle, subInfo);
        }
    }

    public void setMediaTransport(MediaTransport mediaTransport) {
        if (this.mHandle != 0L) {
            TTPlayer._setMediaTransport(this.mHandle, mediaTransport);
        }
    }

    public void setAudioProcessor(AudioProcessor processor) {
        if (this.mHandle != 0L) {
            TTPlayer._setAudioProcessor(this.mHandle, processor);
        }
    }

    @CalledByNative
    public static int isUsedThreadPool() {
        return TTPlayerConfiger.getValue(24, false) ? 1 : 0;
    }

    @CalledByNative
    public static int getThreadPoolStackSize() {
        return TTPlayerConfiger.getValue(25, 32);
    }

    public int setStringOption(int key, String value) {
        return TTPlayer._setStringValue(this.mHandle, key, value);
    }

    public String getStringOption(int key) {
        return TTPlayer._getStringValue(this.mHandle, key);
    }

    public void setCacheFile(String path, int mode) {
        TTPlayer._setCacheFile(this.mHandle, path, mode);
    }

    public int setLongOption(int key, long value) {
        return TTPlayer._setLongValue(this.mHandle, key, value);
    }

    public long getLongOption(int key, long dValue) {
        if (key == 50) {
            return this.mHandle;
        }
        return TTPlayer._getLongValue(this.mHandle, key, dValue);
    }

    public void rotateCamera(float angleX, float angleY) {
        TTPlayer._rotateCamera(this.mHandle, angleX, angleY);
    }

    public int setFloatOption(int key, float value) {
        return TTPlayer._setFloatValue(this.mHandle, key, value);
    }

    public int setDoubleOption(int key, double value) {
        return TTPlayer._setDoubleValue(this.mHandle, key, value);
    }

    public float getFloatOption(int key, float dValue) {
        return TTPlayer._getFloatValue(this.mHandle, key, dValue);
    }

    public double getDoubleOption(int key, double dValue) {
        return TTPlayer._getDoubleValue(this.mHandle, key, dValue);
    }

    public Object getObjectValue(int key) {
        return TTPlayer._getJObjectValue(this.mHandle, key);
    }

    private final native long _create(Context var1, int var2, String var3);

    private static final native void _release(long var0);

    private static final native int _prepare(long var0);

    private static final native void _close(long var0);

    private static final native int _start(long var0);

    private static final native int _reset(long var0);

    private static final native int _pause(long var0);

    private static final native void _stop(long var0);

    private static final native int _seek(long var0, int var2);

    private static final native void _setDataSource(long var0, String var2);

    private static final native void _setDataSourceFd(long var0, int var2);

    private static final native int _setVideoSurface(long var0, Surface var2);

    private static final native int _setSurfaceValue(long var0, long var2);

    private static final native int _getDuration(long var0);

    private static final native int _isPlaying(long var0);

    private static final native int _isLooping(long var0);

    private static final native void _setLooping(long var0, int var2);

    private static final native void _setVolume(long var0, float var2, float var3);

    private static final native int _getCurrentPosition(long var0);

    private static final native int _getVideoWidth(long var0);

    private static final native int _getVideoHeight(long var0);

    private static final native void _mouseEvent(long var0, int var2, int var3, int var4);

    private static final native int _setIntValue(long var0, int var2, int var3);

    private static final native int _getIntValue(long var0, int var2, int var3);

    private static final native void _setSupportFormatNB(int var0);

    private static final native void _setSupprotSampleRates(int[] var0, int var1);

    private static final native String _getAppPath();

    private static final native void _prevClose(long var0);

    private static final native void _registerPlayerInfo();

    private static final native void _setCacheFile(long var0, String var2, int var3);

    private static final native int _setStringValue(long var0, int var2, String var3);

    private static final native String _getStringValue(long var0, int var2);

    private static final native int _setLongValue(long var0, int var2, long var3);

    private static final native long _getLongValue(long var0, int var2, long var3);

    private static final native void _rotateCamera(long var0, float var2, float var3);

    private static final native void _takeScreenshot(long var0);

    private static final native void _switchStream(long var0, int var2, int var3);

    private static final native int _setFloatValue(long var0, int var2, float var3);

    private static final native float _getFloatValue(long var0, int var2, float var3);

    private static final native int _setDoubleValue(long var0, int var2, double var3);

    private static final native double _getDoubleValue(long var0, int var2, double var3);

    private static final native Object _getJObjectValue(long var0, int var2);

    private static final native void _setDataSource(long var0, IMediaDataSource var2);

    private static final native void _setLoadControl(long var0, LoadControl var2);

    private static final native void _setMaskInfo(long var0, MaskInfo var2);

    private static final native void _setSubInfo(long var0, SubInfo var2);

    private static final native void _setMediaTransport(long var0, MediaTransport var2);

    private static final native void _setAudioProcessor(long var0, AudioProcessor var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        mIsIPCPlayer = false;
        mSetLibraryLoader = false;
        mDebugLibLoader = new DefaultLibraryLoader(true);
        Class<TTPlayer> clazz = TTPlayer.class;
        synchronized (TTPlayer.class) {
            TTPlayerLibLoader.loadLibrary();
            try {
                TTPlayer.detectAudioFormat();
            }
            catch (UnsatisfiedLinkError error) {
                String errorInfo = TTPlayerLibLoader.getErrorInfo();
                if (errorInfo != null) {
                    throw new UnsatisfiedLinkError(errorInfo);
                }
                throw error;
            }
            return;
        }
    }

    private static class DefaultLibraryLoader
    implements ILibraryLoader {
        boolean mLoadLibraryPath;

        public DefaultLibraryLoader(boolean loadLibraryPath) {
            this.mLoadLibraryPath = loadLibraryPath;
        }

        @Override
        @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
        public boolean onLoadNativeLibs(List<String> list) {
            for (String library : list) {
                try {
                    if (this.mLoadLibraryPath) {
                        System.load(library);
                        continue;
                    }
                    System.loadLibrary(library);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)("load lib failed = " + e.getMessage()));
                    return false;
                }
            }
            return true;
        }
    }
}

