/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.ss.ttm.net.AVResolver;
import com.ss.ttm.player.AVThreadPool;
import com.ss.ttm.player.AudioProcessor;
import com.ss.ttm.player.FrameMetadataListener;
import com.ss.ttm.player.IMediaDataSource;
import com.ss.ttm.player.ISurfaceListener;
import com.ss.ttm.player.ITTPlayerRef;
import com.ss.ttm.player.Keep;
import com.ss.ttm.player.LoadControl;
import com.ss.ttm.player.MaskInfo;
import com.ss.ttm.player.MediaFormat;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttm.player.MediaPlayerClient;
import com.ss.ttm.player.MediaTransport;
import com.ss.ttm.player.PlaybackParams;
import com.ss.ttm.player.SubInfo;
import com.ss.ttm.player.TTCrashUtil;
import com.ss.ttm.player.TTPlayerConfiger;
import com.ss.ttm.player.TTSurfaceCallback;
import com.ss.ttm.player.TTVersion;
import com.ss.ttm.utils.AVErrorInfo;
import com.ss.ttm.utils.AVLogger;
import com.ss.ttm.utils.AVTime;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
public class TTPlayerClient
extends MediaPlayerClient
implements Handler.Callback,
ISurfaceListener {
    public static final int KEY_IS_CONFIG_PARAMS_OPTION = 100;
    private static final String TAG = TTPlayerClient.class.getSimpleName();
    private MediaPlayer mWrapper;
    private SurfaceHolder mSurfaceHolder;
    private Surface mSurface;
    private Context mContext;
    private String mUri;
    private boolean mScreenOnWhilePlaying;
    private boolean mSeekComplete = true;
    private LinkedList<String> mLogInfo = new LinkedList();
    private TTSurfaceCallback mCallback;
    private PowerManager.WakeLock mWakeLock;
    private boolean mStayAwake;
    private long mListenerState = 0L;
    private volatile boolean mRealsedSurface = false;
    private int mPlayLifeId = -1;
    private final Object mHandlerLocker = new Object();
    private final ReentrantLock mReentrantLock = new ReentrantLock();
    private final ReentrantLock mReentrantLockInRtc = new ReentrantLock();
    private final ReentrantReadWriteLock mReadWritedLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock mReadLock = this.mReadWritedLock.readLock();
    private final ReentrantReadWriteLock.WriteLock mWriteLock = this.mReadWritedLock.writeLock();
    private int mErrorCode = 0;
    private int mRtcPlay = 0;
    private ITTPlayerRef mPlayer;
    private String mBufferingInfo;
    private String mVoiceInfo;
    private StringBuilder mCrashedInfo = new StringBuilder(1024);
    private int mCrashType = -1;
    private int mDisablePlayerStayAwake = 0;
    private Handler mHandler;
    private MediaPlayer.OnLogListener mLogListener;
    private MediaPlayer.OnInfoListener mOnInfoListener;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnExternInfoListener mOnExternInfoListener;
    private MediaPlayer.OnSeekCompleteListener mOnSeekCompleteListener;
    private MediaPlayer.OnBufferingUpdateListener mOnBufferingUpdateListener;
    private MediaPlayer.OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private MediaPlayer.onSARChangedListener mOnSARChangedListener;
    private HashMap<Integer, Integer> mConfigParams = null;
    private int mMediaCodecStopTimeOutMs = -1;

    @Keep
    public static synchronized TTPlayerClient create(MediaPlayer wrapper, Context context) {
        return TTPlayerClient.create(wrapper, context, null);
    }

    @Keep
    public static synchronized TTPlayerClient create(MediaPlayer wrapper, Context context, HashMap<Integer, Integer> configParams) {
        TTVersion.saveVersionInfo();
        TTPlayerClient client = new TTPlayerClient(context, configParams);
        ITTPlayerRef playerRef = ITTPlayerRef.create(context, client, configParams);
        if (playerRef == null) {
            return null;
        }
        client.mPlayer = playerRef;
        client.mWrapper = wrapper;
        return client;
    }

    private TTPlayerClient(Context context, HashMap<Integer, Integer> configParams) {
        this.mConfigParams = configParams;
        this.mRealsedSurface = false;
        this.mCallback = new TTSurfaceCallback(this);
        this.mContext = context;
        this.mHandler = Looper.myLooper() != null ? new Handler((Handler.Callback)this) : new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    private boolean isValid() {
        return this.mPlayer != null && this.mPlayer.isValid();
    }

    protected void updateLifeId() {
        try {
            this.mReentrantLock.lock();
            this.mPlayLifeId = this.mPlayer.getLifeId();
        }
        finally {
            if (this.mReentrantLock.isLocked()) {
                this.mReentrantLock.unlock();
            }
        }
    }

    @Override
    @Deprecated
    public void prevClose() {
        this.mRealsedSurface = true;
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.removeCallback((SurfaceHolder.Callback)this.mCallback);
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.prevClose();
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        this.mSurface = null;
    }

    @Override
    public void releaseAsync() {
        this.mRealsedSurface = true;
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.removeCallback((SurfaceHolder.Callback)this.mCallback);
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.prevClose();
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        this.mSurface = null;
        new Thread(new Runnable(){

            @Override
            public void run() {
                TTPlayerClient.this.release();
            }
        }).start();
    }

    public void close() {
        this.mRealsedSurface = true;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.close();
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        String errorInfo;
        Object player;
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mWriteLock.lock();
        try {
            player = this.mPlayer;
            this.mPlayer = null;
            this.mPlayLifeId = -1;
            if (player != null) {
                ((ITTPlayerRef)player).release();
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.removeCallback((SurfaceHolder.Callback)this.mCallback);
            this.mSurfaceHolder = null;
            this.mRealsedSurface = true;
        }
        this.mSurface = null;
        player = this.mHandlerLocker;
        synchronized (player) {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler = null;
            }
        }
        if (this.mLogListener != null && (errorInfo = this.getPlayerErrorInfo()) != null && errorInfo.length() > 0) {
            this.mLogListener.onLogInfo(this.mWrapper, errorInfo);
        }
        this.mContext = null;
    }

    @Override
    public void start() {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.start();
                this.updateLifeId();
                this.mRtcPlay = this.mPlayer.getIntOption(800, 0);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        this.stayAwake(true);
    }

    @Override
    public void pause() {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.pause();
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        this.stayAwake(false);
    }

    @Override
    public void reset() {
        this.mWriteLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.reset();
                if (this.mSurfaceHolder != null) {
                    this.mPlayer.setSurface(this.mSurfaceHolder.getSurface());
                }
                this.mHandler.removeCallbacksAndMessages(null);
                this.mErrorCode = 0;
                this.mLogInfo.clear();
                this.updateLifeId();
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    @Override
    public void stop() {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.stop();
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        this.stayAwake(false);
    }

    @Override
    public void prepare() {
        this.prepareAsync();
    }

    @Override
    public void prepareAsync() {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mErrorCode = 0;
                this.mLogInfo.clear();
                if (this.mRealsedSurface) {
                    this.mPlayer.setSurface(this.mSurfaceHolder.getSurface());
                    this.mRealsedSurface = false;
                }
                this.mPlayer.prepare();
                this.updateLifeId();
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void takeScreenshot(MediaPlayer.OnScreenshotListener listener) {
        if (this.mPlayer != null && listener != null) {
            this.mListenerState |= 0x8000L;
            this.mReadLock.lock();
            try {
                if (this.isValid()) {
                    this.mPlayer.setNotifyState(this.mListenerState);
                    this.mPlayer.setOnScreenshotListener(listener);
                    this.mPlayer.takeScreenshot();
                }
            }
            finally {
                this.mReadLock.unlock();
            }
        }
    }

    @Override
    public void switchStream(int bitrate, int streamType) {
        if (this.mPlayer != null) {
            this.mReadLock.lock();
            try {
                if (this.isValid()) {
                    this.mPlayer.switchStream(bitrate, streamType);
                }
            }
            finally {
                this.mReadLock.unlock();
            }
        }
    }

    @Override
    public int getCurrentPosition() {
        int ret = 0;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(2, 0);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public int getVideoHeight() {
        int ret = 0;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(4, 0);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public int getVideoWidth() {
        int ret = 0;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(3, 0);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public int getDuration() {
        int ret = 0;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(1, 0);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.removeCallback((SurfaceHolder.Callback)this.mCallback);
        }
        this.mSurfaceHolder = surfaceHolder;
        Surface surface = null;
        if (surfaceHolder != null) {
            this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this.mCallback);
            surface = this.mSurfaceHolder.getSurface();
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setSurface(surface);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        this.updateSurfaceScreenOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (uri == null) {
            return;
        }
        this.setDataSource(context, uri);
        if (headers == null || headers.size() == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.append(entry.getKey()).append(":").append(entry.getValue()).append("\r\n");
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setStringOption(20, builder.toString());
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (uri == null) {
            return;
        }
        String scheme = uri.getScheme();
        if ("content".equals(scheme) && "settings".equals(uri.getAuthority()) && (uri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)RingtoneManager.getDefaultType((Uri)uri))) == null) {
            throw new FileNotFoundException("Failed to resolve default ringtone");
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            this.setDataSource(fd.getFileDescriptor());
            return;
        }
        this.setDataSource(uri.toString());
    }

    public void setDataSource(FileDescriptor fd) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup((FileDescriptor)fd);){
            this.mPlayer.setDataSourceFd(pfd.getFd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataSource(FileDescriptor fd, long offset, long length) throws IllegalStateException, IllegalArgumentException, IOException {
        this.setDataSource(fd);
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setLongOption(135, offset);
                this.mPlayer.setLongOption(136, length);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setDataSource(String path) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        String url = path.toLowerCase(Locale.US);
        this.mUri = url.indexOf("://") <= 0 ? "file://" + path : path;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setDataSource(this.mUri);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setDataSource(IMediaDataSource dataSource) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException("null mediadatasource pointer.");
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setDataSource(dataSource);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public String getDataSource() {
        return this.mUri;
    }

    @Override
    public boolean isPlaying() {
        boolean ret = false;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(6, 0) == 1;
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public boolean isLooping() {
        boolean ret = false;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(5, 0) == 1;
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public void setLooping(boolean b) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setLooping(b ? 1 : 0);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setVolume(float left, float right) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setVolume(left, right);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEvent(int action, int deltaX, int deltaY) {
        int newAction = 0;
        switch (action) {
            case 0: {
                newAction = 1;
                break;
            }
            case 1: {
                newAction = 3;
                break;
            }
            case 2: {
                newAction = 2;
                break;
            }
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.mouseEvent(newAction, deltaX, deltaY);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void rotateCamera(float angleX, float angleY) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.rotateCamera(angleX, angleY);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void seekTo(int msec) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mSeekComplete = false;
                this.mPlayer.seekTo(msec);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIntOption(int key, int dValue) {
        if (key == 5000) {
            return this.mErrorCode;
        }
        if (key == 26) {
            return this.mCrashType;
        }
        int ret = dValue;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(key, dValue);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setIntOption(int key, int value) {
        int ret = -1;
        if (key == 41) {
            AVResolver.HOST_MAX_CACHE_TIME = value;
            return 0;
        }
        if (key == 5003) {
            this.mDisablePlayerStayAwake = value;
            return 0;
        }
        if (key == 952) {
            this.mMediaCodecStopTimeOutMs = value;
            return 0;
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.setIntOption(key, value);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setStringOption(int key, String value) {
        int ret = -1;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.setStringOption(key, value);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public String getStringOption(int key) {
        if (key == 5001) {
            return this.getPlayerCrashedInfo();
        }
        if (key == 5002) {
            return this.mLogInfo == null || this.mLogInfo.size() == 0 ? null : this.getPlayerErrorInfo();
        }
        String result = null;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                result = this.mPlayer.getStringOption(key);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setLongOption(int key, long value) {
        int ret = -1;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.setLongOption(key, value);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLongOption(int key, long dValue) {
        long ret = dValue;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getLongOption(key, dValue);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloatOption(int key, float dValue) {
        float ret = dValue;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getFloatOption(key, dValue);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFloatOption(int key, float value) {
        int ret = -1;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.setFloatOption(key, value);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    public Object getObjectOption(int key) {
        Object ret = null;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getObjectOption(key);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public int getVideoType() {
        int ret = 0;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(11, 0);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public void setPanoVideoControlModel(int model) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setIntOption(11, model);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public boolean isMute() {
        boolean ret = false;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getIntOption(12, 0) == 1;
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public void setIsMute(boolean isMute) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setIntOption(12, isMute ? 1 : 0);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setSurface(Surface surface) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mSurface = surface;
                this.mPlayer.setSurface(surface);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setCacheFile(String path, int mode) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setCacheFile(path, mode);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                Log.w((String)TAG, (String)"setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    public void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null && this.mDisablePlayerStayAwake == 0) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    @SuppressLint(value={"Wakelock"})
    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    @Override
    @SuppressLint(value={"Wakelock"})
    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, TTPlayerClient.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleNotify(int lifeId, int what, int parameter, String info) {
        switch (what) {
            case 3: {
                if (this.mOnBufferingUpdateListener == null) return;
                this.mOnBufferingUpdateListener.onBufferingUpdate(this.mWrapper, parameter);
                return;
            }
            case 12: {
                this.sendSeekCompleted(lifeId);
                return;
            }
            case 13: {
                this.stayAwake(false);
                this.sendSeekCompleted(lifeId);
                this.sendCompletioned(lifeId);
                return;
            }
            case 0: 
            case 45: {
                this.stayAwake(false);
                if (parameter == -499989) {
                    if (this.mConfigParams != null && this.mConfigParams.get(100) == 1) {
                        this.mConfigParams.put(8, 1);
                    } else {
                        TTPlayerConfiger.setValue(8, true);
                    }
                }
                this.sendSeekCompleted(lifeId);
                this.sendErrorInfo(parameter, lifeId);
                return;
            }
            case 20000: {
                if (this.mErrorCode == -2139062143) {
                    return;
                }
                this.mErrorCode = -2139062143;
                this.mWriteLock.lock();
                try {
                    ITTPlayerRef player = this.mPlayer;
                    if (player == null) return;
                    this.mPlayer = null;
                    player.invalid();
                }
                finally {
                    this.mWriteLock.unlock();
                }
                if (this.mConfigParams != null && this.mConfigParams.get(100) == 1) {
                    this.mConfigParams.put(7, 1);
                } else {
                    TTPlayerConfiger.setValue(7, true);
                }
                this.stayAwake(false);
                this.sendSeekCompleted(lifeId);
                this.sendErrorInfo(parameter, lifeId);
                this.sendCompletioned(lifeId);
                return;
            }
            case 2: {
                if (this.mOnPreparedListener == null) return;
                this.mOnPreparedListener.onPrepared(this.mWrapper);
                return;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 1000: {
                this.notifyInfo(what, parameter);
                return;
            }
            case 19: 
            case 33: 
            case 40: 
            case 43: 
            case 44: 
            case 59: {
                this.onExternInfo(what, info);
                return;
            }
            case 6: {
                if (this.mOnVideoSizeChangedListener == null) return;
                this.mOnVideoSizeChangedListener.onVideoSizeChanged(this.mWrapper, parameter & 0xFFFF, parameter >> 16);
                return;
            }
            case 23: {
                if (this.mOnSARChangedListener == null) return;
                this.mOnSARChangedListener.onSARChanged(this.mWrapper, parameter & 0xFFFF, parameter >> 16);
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onExternInfo(int what, String info) {
        if (this.mRtcPlay != 0) {
            try {
                this.mReentrantLockInRtc.lock();
                if (this.mOnExternInfoListener == null || info == null) return;
                this.mOnExternInfoListener.onExternInfo(this.mWrapper, what, info);
                return;
            }
            finally {
                this.mReentrantLockInRtc.unlock();
            }
        } else {
            if (this.mOnExternInfoListener == null || info == null) return;
            this.mOnExternInfoListener.onExternInfo(this.mWrapper, what, info);
        }
    }

    private void notifyInfo(int what, int parameter) {
        if (this.mOnInfoListener == null) {
            return;
        }
        int info = -1;
        switch (what) {
            case 8: {
                info = 801;
                break;
            }
            case 47: {
                info = -268435408;
                break;
            }
            case 4: {
                info = 701;
                break;
            }
            case 5: {
                info = 702;
                break;
            }
            case 10: {
                info = 901;
                break;
            }
            case 7: {
                info = 3;
                break;
            }
            case 29: {
                info = 0xF00000C;
                break;
            }
            case 28: {
                info = 0xF00000B;
                break;
            }
            case 27: {
                info = 0xF00000A;
                break;
            }
            case 34: {
                info = -268435442;
                break;
            }
            case 35: {
                info = -268435441;
                break;
            }
            case 36: {
                info = -268435440;
                break;
            }
            case 37: {
                info = -268435439;
                break;
            }
            case 39: {
                info = -268435437;
                break;
            }
            case 53: {
                info = -268435405;
                break;
            }
            case 54: {
                info = -268435404;
                break;
            }
            case 41: {
                info = -268435424;
                break;
            }
            case 42: {
                info = -268435423;
                break;
            }
            case 9: {
                info = 802;
                break;
            }
            case 21: {
                info = 0xF000004;
                break;
            }
            case 22: {
                info = 0xF000005;
                break;
            }
            case 20: {
                info = 0xF000003;
                break;
            }
            case 23: {
                info = 0xF000006;
                break;
            }
            case 24: {
                info = 0xF000007;
                break;
            }
            case 25: {
                info = 0xF000008;
                break;
            }
            case 26: {
                info = 0xF000009;
                break;
            }
            case 32: {
                info = 0xF00000D;
                break;
            }
            case 38: {
                info = -268435438;
                break;
            }
            case 49: {
                info = -268435392;
                break;
            }
            case 50: {
                info = -268435391;
                break;
            }
            case 51: {
                info = -268435407;
                break;
            }
            case 52: {
                info = -268435406;
                break;
            }
            case 30: {
                info = -268435390;
                break;
            }
            case 1000: {
                info = 0x1000001;
                break;
            }
            case 57: {
                info = -268435403;
                break;
            }
            case 58: {
                info = -268435402;
            }
        }
        this.mOnInfoListener.onInfo(this.mWrapper, info, parameter);
    }

    @Override
    public void setOnLogListener(MediaPlayer.OnLogListener listener) {
        this.mLogListener = listener;
    }

    @Override
    public void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
        this.mListenerState |= 8L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
        this.mListenerState |= 0x2000L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        this.mOnErrorListener = listener;
        this.mListenerState |= 0x200000000001L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setOnInfoListener(MediaPlayer.OnInfoListener listener) {
        this.mOnInfoListener = listener;
        this.mListenerState |= 0x67E86FD7F7007B2L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setOnExternInfoListener(MediaPlayer.OnExternInfoListener listener) {
        this.mOnExternInfoListener = listener;
        this.mListenerState |= 0x800190200080000L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setFrameMetadataListener(FrameMetadataListener listener) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setFrameMetadataListener(listener);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
        this.mListenerState |= 4L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
        this.mListenerState |= 0x1000L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
        this.mListenerState |= 0x40L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setOnSARChangedListener(MediaPlayer.onSARChangedListener listener) {
        this.mOnSARChangedListener = listener;
        this.mListenerState |= 0x800000L;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setNotifyState(this.mListenerState);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public void setLoadControl(LoadControl control) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setLoadControl(control);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public void setMaskInfo(MaskInfo maskInfo) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setMaskInfo(maskInfo);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public void setSubInfo(SubInfo subInfo) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setSubInfo(subInfo);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void setMediaTransport(MediaTransport transport) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setMediaTransport(transport);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public void setAudioProcessor(AudioProcessor processor) {
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setAudioProcessor(processor);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    protected void onPlayLogInfo(int type, int errorCode, String info) {
        if (type == 2) {
            if (errorCode == 1) {
                this.mVoiceInfo = info;
            } else if (errorCode == 0) {
                this.mBufferingInfo = info;
            }
            return;
        }
        if (type == 0) {
            this.mErrorCode = errorCode;
        }
        if (info != null) {
            if (this.mLogInfo.size() > 40) {
                this.mLogInfo.removeFirst();
            }
            this.mLogInfo.addLast(String.format(Locale.US, "%s&&time:%d", info, System.currentTimeMillis()));
        }
    }

    private void sendSeekCompleted(int lifeId) {
        if (!this.mSeekComplete && this.mOnSeekCompleteListener != null) {
            this.mSeekComplete = true;
            if (lifeId >= this.mPlayLifeId) {
                this.mOnSeekCompleteListener.onSeekComplete(this.mWrapper);
            }
        }
    }

    private void sendCompletioned(int lifeId) {
        try {
            this.mReentrantLock.lock();
            if (this.mOnCompletionListener != null && lifeId >= this.mPlayLifeId) {
                this.mOnCompletionListener.onCompletion(this.mWrapper);
            }
        }
        finally {
            if (this.mReentrantLock.isLocked()) {
                this.mReentrantLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendErrorInfo(int parameter, int lifeId) {
        try {
            this.mReentrantLock.lock();
            if (this.mOnErrorListener != null && lifeId >= this.mPlayLifeId) {
                int tmpErrorCode = -1048575;
                if (this.mErrorCode == 0) {
                    if (parameter != 0) {
                        tmpErrorCode = parameter;
                    }
                } else {
                    tmpErrorCode = this.mErrorCode;
                }
                if (!this.mOnErrorListener.onError(this.mWrapper, tmpErrorCode, 0) && this.mOnCompletionListener != null) {
                    // empty if block
                }
            }
        }
        finally {
            if (this.mReentrantLock.isLocked()) {
                this.mReentrantLock.unlock();
            }
        }
    }

    public boolean handleMessage(Message msg) {
        this.handleNotify(msg.arg2, msg.what, msg.arg1, msg.obj instanceof String ? (String)msg.obj : null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlayerNotify(int lifeId, int what, int parameter, String info) {
        Object object = this.mHandlerLocker;
        synchronized (object) {
            if (this.mHandler == null) {
                return;
            }
            if (what == 40 && info != null) {
                this.handleNotify(lifeId, what, parameter, info);
                return;
            }
            Message message = this.mHandler.obtainMessage(what, parameter, lifeId);
            message.obj = info;
            message.sendToTarget();
        }
    }

    @Override
    public void onSurfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        if (this.mRealsedSurface) {
            return;
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                if (holder != this.mSurfaceHolder) {
                    if (this.mSurfaceHolder != null) {
                        this.mSurfaceHolder.removeCallback((SurfaceHolder.Callback)this.mCallback);
                    }
                    this.mSurfaceHolder = holder;
                    if (this.mSurfaceHolder != null) {
                        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this.mCallback);
                    }
                }
                this.mPlayer.setSurface(holder.getSurface());
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void onSurfaceChanged(SurfaceHolder holder) {
        AVLogger.k(TAG, "surface is change");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSurfaceDestroyed(SurfaceHolder holder) {
        if (this.mRealsedSurface) {
            return;
        }
        if (this.mMediaCodecStopTimeOutMs > 0) {
            Future<String> future = AVThreadPool.addTask(new Callable<String>(){

                @Override
                public String call() {
                    try {
                        TTPlayerClient.this.mReadLock.lockInterruptibly();
                        try {
                            if (TTPlayerClient.this.isValid()) {
                                TTPlayerClient.this.mPlayer.setSurface(null);
                            }
                        }
                        finally {
                            TTPlayerClient.this.mReadLock.unlock();
                        }
                    }
                    catch (InterruptedException e) {
                        Log.e((String)TAG, (String)"mPlayer setsurface null failed.");
                    }
                    return "OK";
                }
            });
            try {
                String string = future.get(this.mMediaCodecStopTimeOutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Log.e((String)TAG, (String)"set surface time out");
            }
            return;
        }
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                this.mPlayer.setSurface(null);
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    private String getPlayerCrashedInfo() {
        int port = TTPlayerConfiger.getValue(18, 1);
        StringBuilder crashInfo = new StringBuilder();
        Context context = null;
        context = this.mPlayer == null ? this.mContext : this.mPlayer.getContext();
        if (context == null) {
            return "context is null";
        }
        String path = null;
        String info = null;
        if (port > 1) {
            path = TTCrashUtil.existsCrashFilePath(context);
            if (path != null && (info = TTCrashUtil.getCrashFileContext(context, path, crashInfo)) != null) {
                TTCrashUtil.deleteCrashFile(this.mContext, path);
                this.mCrashType = 1;
                if (TTPlayerConfiger.getValue(5, false)) {
                    Log.i((String)"ttplayer", (String)"<TTPlayerIPClient,getCrashedInfo>find breakpad file");
                }
                return info;
            }
            AVErrorInfo.setupPhoneInfo(context, crashInfo);
        }
        if ((path = TTPlayerConfiger.getValue(19, null)) != null && (info = TTCrashUtil.getCrashFileContext(this.mContext, path, crashInfo)) != null) {
            TTCrashUtil.deleteCrashFile(this.mContext, path);
            this.mCrashType = 1;
            if (TTPlayerConfiger.getValue(5, false)) {
                Log.i((String)"ttplayer", (String)"<TTPlayerIPClient,getCrashedInfo>find breakpad file");
            }
            return info;
        }
        crashInfo.append("\ncreate time:" + AVTime.getFormatNow());
        crashInfo.append("\nport version:").append(port);
        crashInfo.append("\nstart service info:").append(TTPlayerConfiger.getValue(16, "not find service start info"));
        crashInfo.append("\nstop service info:").append(TTPlayerConfiger.getValue(12, "not find service stop info"));
        crashInfo.append("\ncrash:").append(TTPlayerConfiger.getValue(7, false));
        crashInfo.append("\nsdk info:").append(TTPlayerConfiger.getValue(15, "not find sdk info"));
        crashInfo.append("\ntimeout count:").append(TTPlayerConfiger.getValue(10, -1));
        crashInfo.append("\nforeground:").append(TTPlayerConfiger.getValue(21, -1));
        crashInfo.append("\non screen:").append(TTPlayerConfiger.getValue(22, -1));
        crashInfo.append("\n battery info:").append(TTPlayerConfiger.getValue(23, "not find"));
        crashInfo.append("\nurl:").append(this.mUri);
        crashInfo.append("\ncrash:\r\n").append((CharSequence)this.mCrashedInfo);
        this.mCrashType = 0;
        if (port > 1) {
            if (TTPlayerConfiger.getValue(5, false)) {
                Log.i((String)"ttplayer", (String)("<TTPlayerIPClient,getCrashedInfo>" + crashInfo.toString()));
            }
            return TTCrashUtil.getBase64SampleCrash(crashInfo.toString());
        }
        return crashInfo.toString();
    }

    protected void onCrashedInfo(String info) {
        if (this.mCrashedInfo.length() < 1024) {
            this.mCrashedInfo.append(info).append("\n");
        }
    }

    private String getPlayerErrorInfo() {
        try {
            StringBuilder erroeInfo = new StringBuilder();
            if (this.mLogInfo != null && this.mLogInfo.size() > 0 || this.mBufferingInfo != null || this.mVoiceInfo != null) {
                AVErrorInfo.setupErrorInfo(this.mContext, erroeInfo, "error", "play error", this.mUri);
                for (String string : this.mLogInfo) {
                    erroeInfo.append(string).append("\n");
                }
                if (this.mBufferingInfo != null) {
                    erroeInfo.append(this.mBufferingInfo).append("\n");
                    this.mBufferingInfo = null;
                }
                if (this.mVoiceInfo != null) {
                    erroeInfo.append(this.mVoiceInfo).append("\n");
                    this.mVoiceInfo = null;
                }
            }
            return erroeInfo.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getType() {
        int ret = 0;
        this.mReadLock.lock();
        try {
            if (this.isValid()) {
                ret = this.mPlayer.getType();
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return ret;
    }

    @Override
    public void setPlaybackParams(PlaybackParams params) {
        this.mReadLock.lock();
        try {
            if (this.isValid() && params != null && params.getSpeed() != -1.0f) {
                this.mPlayer.setFloatOption(60, params.getSpeed());
            }
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public void selectTrack(int index) {
        this.mReadLock.lock();
        if (this.mPlayer != null && index == 0) {
            this.mPlayer.setIntOption(261, 0);
        }
        this.mReadLock.unlock();
    }

    @Override
    public void deselectTrack(int index) {
        this.mReadLock.lock();
        if (this.mPlayer != null && index == 0) {
            this.mPlayer.setIntOption(261, 1);
        } else if (this.mPlayer != null) {
            this.mPlayer.setIntOption(65, index << 8 | 0);
        }
        this.mReadLock.unlock();
    }

    @Override
    public int getSelectedTrack(int trackType) {
        if (trackType == 2) {
            return 1;
        }
        if (trackType == 1) {
            return 0;
        }
        if (trackType == 4) {
            return 2;
        }
        return -1;
    }

    @Override
    public MediaPlayer.TrackInfo[] getTrackInfo() {
        MediaPlayer.TrackInfo[] info = new MediaPlayer.TrackInfo[]{new MediaPlayer.TrackInfo(0, new MediaFormat()), new MediaPlayer.TrackInfo(1, new MediaFormat()), new MediaPlayer.TrackInfo(2, new MediaFormat())};
        return info;
    }

    static {
        TTVersion.saveVersionInfo();
    }
}

