/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class TTPlayerConfiger {
    public static final String TAG = "ttplayer";
    public static final boolean DEBUG = false;
    public static final int IS_TIME_OUT_COUNT = 3;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int KEY_IS_CHECK_TTPLAYER_MODEL = 0;
    public static final int KEY_IS_TTPLAYER_ON = 1;
    public static final int KEY_IS_IPTTPLAYER_ON = 2;
    public static final int KEY_IS_CHECK_LIB = 3;
    public static final int KEY_IS_THROW_CRASH = 4;
    public static final int KEY_IS_PRINT_INFO = 5;
    public static final int KEY_IS_DEBUG_MODEL = 6;
    public static final int KEY_IS_CRASHED = 7;
    public static final int KEY_IS_OPEN_DEVICE_FAIL = 8;
    public static final int KEY_IS_TIMEOUT_COUNT = 10;
    public static final int KEY_IS_FORBID_CREATED_OS_PLAYER = 11;
    public static final int KEY_IS_STOP_SERVICE = 12;
    public static final int KEY_IS_SDK_VERSION = 13;
    public static final int KEY_IS_SDK_VERSION_NAME = 14;
    public static final int KEY_IS_SDK_VERSION_INFO = 15;
    public static final int KEY_IS_START_SERVICE = 16;
    public static final int KEY_IS_CRASH_FILE_NAME = 17;
    public static final int KEY_IS_PORT_VERSION = 18;
    public static final int KEY_IS_CRASH_PATH = 19;
    public static final int KEY_IS_LOG_FILE_DIR = 20;
    public static final int KEY_IS_FOREGROUND = 21;
    public static final int KEY_IS_ON_SCREEN = 22;
    public static final int KEY_IS_BATTERY_INFO = 23;
    public static final int KEY_IS_USED_THREAD_POOL = 24;
    public static final int KEY_IS_THREAD_POOL_STACK_SIZE = 25;
    public static final int KEY_IS_EXO_PLAYER_ON = 26;
    private static final int PORT_VERSION = 2;
    private static final int VERSION = 1;
    private static final String VERSION_NAME = "999.999.999.9";
    private static final String VERSION_INFO = "version code:1,name:999.999.999.9default sdk info 2016-12-05";
    private static String APP_PATH;
    private static String PLAYER_LIBRARY_NAME;
    private static String LIBRARY_DIR;
    private static String TTPLAYER_FILE_CACHE_DIR;
    private static String CRASH_FILE_NAME;
    private static String CRASH_FILE_PATH;
    public static boolean IS_PRINT_INFO;
    public static final int DEFAULT_POOL_STACK_SIZE = 32;
    private static final SparseArray<Value> KEYS;

    public static final int getVersion() {
        return 1;
    }

    public static final String getValue(int key, String dValue) {
        if (key == 17) {
            return CRASH_FILE_NAME;
        }
        Value object = (Value)KEYS.get(key);
        if (object != null && object instanceof StringValue) {
            return ((StringValue)object).getValue();
        }
        return dValue;
    }

    public static final boolean getValue(int key, boolean dValue) {
        Object object = KEYS.get(key);
        if (object != null && object instanceof IntValue) {
            return ((IntValue)object).getValue() == 1;
        }
        return dValue;
    }

    public static final int getValue(int key, int dValue) {
        Object object = KEYS.get(key);
        if (object != null && object instanceof IntValue) {
            return ((IntValue)object).getValue();
        }
        return dValue;
    }

    public static final long getValue(int key, long dValue) {
        Object object = KEYS.get(key);
        if (object != null && object instanceof LongValue) {
            return ((LongValue)object).getValue();
        }
        return dValue;
    }

    public static final void setValue(int key, boolean value) {
        TTPlayerConfiger.setValue(key, value ? 1 : 0);
    }

    public static final void setValue(int key, int value) {
        Object object = KEYS.get(key);
        if (object != null) {
            if (object instanceof IntValue) {
                if (key == 2 && TTPlayerConfiger.getValue(6, false)) {
                    return;
                }
                IntValue intValue = (IntValue)object;
                intValue.setValue(value);
                return;
            }
            KEYS.remove(key);
        }
        IntValue intValue = new IntValue(key, value);
        KEYS.append(key, (Object)intValue);
    }

    public static final void setValue(int key, long value) {
        Object object = KEYS.get(key);
        if (object != null) {
            if (object instanceof LongValue) {
                LongValue intValue = (LongValue)object;
                intValue.setValue(value);
                return;
            }
            KEYS.remove(key);
        }
        LongValue intValue = new LongValue(key, value);
        KEYS.append(key, (Object)intValue);
    }

    public static final void setValue(int key, String value) {
        Object object = KEYS.get(key);
        if (object != null) {
            if (object instanceof StringValue) {
                StringValue intValue = (StringValue)object;
                intValue.setValue(value);
                return;
            }
            KEYS.remove(key);
        }
        StringValue intValue = new StringValue(key, value);
        KEYS.append(key, (Object)intValue);
    }

    public static final boolean isOnTTPlayer() {
        if (TTPlayerConfiger.getValue(6, 0) == 1) {
            return true;
        }
        if (TTPlayerConfiger.getValue(1, 0) == 0) {
            return false;
        }
        if (TTPlayerConfiger.getValue(11, 0) == 1) {
            return true;
        }
        if (TTPlayerConfiger.getValue(7, 0) == 1 || TTPlayerConfiger.getValue(8, 0) == 1) {
            return false;
        }
        return TTPlayerConfiger.getValue(10, 0) < 3;
    }

    public static final void setLibraryName(String name) {
        PLAYER_LIBRARY_NAME = name;
    }

    public static final void setLibrarysDir(String dir) {
        LIBRARY_DIR = dir;
    }

    public static final void setCrashFileName(String name) {
        CRASH_FILE_NAME = name;
    }

    public static final void setCrashFilePath(String path) {
        CRASH_FILE_PATH = path;
    }

    public static final String getAppFilesPath(Context context) {
        if (APP_PATH != null) {
            return APP_PATH;
        }
        if (context == null) {
            return null;
        }
        try {
            APP_PATH = context.getApplicationContext().getFilesDir().getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
        return APP_PATH;
    }

    public static final String getAppCrashFilePath2(Context context) {
        if (context != null && APP_PATH == null) {
            APP_PATH = context.getApplicationContext().getFilesDir().getAbsolutePath();
        }
        if (CRASH_FILE_PATH == null) {
            if (APP_PATH == null) {
                APP_PATH = TTPlayerConfiger.getAppFilesPath(context);
            }
            if (TTPlayerConfiger.isPrintInfo()) {
                Log.i((String)TAG, (String)("<TTPlayerConfigure.java,getAppCrashFilePath2,211>app files path:" + APP_PATH));
            }
            if (APP_PATH != null) {
                return APP_PATH + File.separatorChar + CRASH_FILE_NAME;
            }
            return null;
        }
        if (TTPlayerConfiger.isPrintInfo()) {
            Log.i((String)TAG, (String)("<TTPlayerConfigure.java,getAppCrashFileStorePath,195>carsh file path:" + CRASH_FILE_PATH));
        }
        return CRASH_FILE_PATH;
    }

    public static final String getPlugerCrashFilePath(Context context) {
        StringBuilder builder = new StringBuilder();
        builder.append(APP_PATH).append(File.separatorChar);
        builder.append("plugins").append(File.separatorChar);
        builder.append("com.ss.ttm").append(File.separatorChar);
        builder.append("data").append(File.separatorChar);
        builder.append("files").append(File.separatorChar);
        builder.append(CRASH_FILE_NAME);
        return builder.toString();
    }

    public static final String getExternalStorageDirectoryCrashFilePath(Context context) {
        return null;
    }

    @Deprecated
    public static final String getAppCrashFileStorePath(Context context) {
        if (context != null && APP_PATH == null) {
            APP_PATH = context.getApplicationContext().getFilesDir().getAbsolutePath();
        }
        if (CRASH_FILE_PATH == null) {
            if (APP_PATH == null) {
                APP_PATH = TTPlayerConfiger.getAppFilesPath(context);
            }
            if (TTPlayerConfiger.isPrintInfo()) {
                Log.i((String)TAG, (String)("<TTPlayerConfigure.java,getAppCrashFileStorePath,245>app files path:" + APP_PATH));
            }
            if (APP_PATH != null) {
                return APP_PATH + File.separatorChar + CRASH_FILE_NAME;
            }
            return null;
        }
        if (TTPlayerConfiger.isPrintInfo()) {
            Log.i((String)TAG, (String)("<TTPlayerConfigure.java,getAppCrashFileStorePath,253>carsh file path:" + CRASH_FILE_PATH));
        }
        return CRASH_FILE_PATH;
    }

    @Deprecated
    public static final String getAppCrashFilePath(Context context) {
        String path;
        File file;
        if (CRASH_FILE_PATH == null && !(file = new File(path = TTPlayerConfiger.getAppCrashFileStorePath(context))).exists()) {
            StringBuilder builder = new StringBuilder();
            builder.append(APP_PATH).append(File.separatorChar);
            builder.append("plugins").append(File.separatorChar);
            builder.append("com.ss.ttm").append(File.separatorChar);
            builder.append("data").append(File.separatorChar);
            builder.append("files").append(File.separatorChar);
            builder.append(CRASH_FILE_NAME);
            return builder.toString();
        }
        if (TTPlayerConfiger.isPrintInfo()) {
            Log.i((String)TAG, (String)("<TTPlayerConfigure.java,getAppCrashFileStorePath,278>carsh file path:" + CRASH_FILE_PATH));
        }
        return CRASH_FILE_PATH;
    }

    public static final String getAppFileCachePath(Context context) {
        if (context != null && APP_PATH == null) {
            APP_PATH = context.getApplicationContext().getFilesDir().getAbsolutePath();
        }
        if (TTPLAYER_FILE_CACHE_DIR != null) {
            return TTPLAYER_FILE_CACHE_DIR;
        }
        if (APP_PATH != null) {
            return APP_PATH;
        }
        if (context == null) {
            return null;
        }
        try {
            APP_PATH = context.getApplicationContext().getFilesDir().getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
        return APP_PATH;
    }

    public static boolean isPrintInfo() {
        return IS_PRINT_INFO;
    }

    public static void checkDebugTTPlayerLib() {
    }

    public static String getPlayerLibrarysDir(Context context) {
        if (LIBRARY_DIR == null) {
            LIBRARY_DIR = TTPlayerConfiger.getAppFilesPath(context) + File.separatorChar;
            return LIBRARY_DIR;
        }
        if (LIBRARY_DIR.endsWith(String.valueOf(File.separatorChar))) {
            return LIBRARY_DIR;
        }
        return LIBRARY_DIR + File.separatorChar;
    }

    public static String getPlayerLibraryPath(Context context) {
        if (APP_PATH == null || context != null) {
            APP_PATH = TTPlayerConfiger.getAppFilesPath(context);
        }
        if (APP_PATH == null && LIBRARY_DIR == null) {
            return null;
        }
        if (LIBRARY_DIR != null) {
            if (LIBRARY_DIR.endsWith(String.valueOf(File.separatorChar))) {
                return LIBRARY_DIR + PLAYER_LIBRARY_NAME;
            }
            return LIBRARY_DIR + File.separatorChar + PLAYER_LIBRARY_NAME;
        }
        return APP_PATH + File.separatorChar + PLAYER_LIBRARY_NAME;
    }

    public static String getPlayerLibraryPath() {
        return TTPlayerConfiger.getPlayerLibraryPath(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean copyFile(String destFileName, String srcFileName, boolean overlay, boolean deleteSrc) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            return false;
        }
        if (!srcFile.isFile()) {
            return false;
        }
        File destFile = new File(destFileName);
        if (destFile.exists()) {
            if (overlay) {
                new File(destFileName).delete();
            }
        } else if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            return false;
        }
        int byteread = 0;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            out.close();
            ((InputStream)in).close();
            if (deleteSrc) {
                srcFile.delete();
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final boolean moveFile(String destFileName, String srcFileName, boolean overlay) {
        return TTPlayerConfiger.copyFile(destFileName, srcFileName, overlay, true);
    }

    static {
        PLAYER_LIBRARY_NAME = "libttmplayer.so";
        LIBRARY_DIR = null;
        TTPLAYER_FILE_CACHE_DIR = null;
        CRASH_FILE_NAME = "ttplayer_crash.log";
        CRASH_FILE_PATH = null;
        IS_PRINT_INFO = false;
        KEYS = new SparseArray();
        TTPlayerConfiger.setValue(13, 1);
        TTPlayerConfiger.setValue(14, VERSION_NAME);
        TTPlayerConfiger.setValue(15, VERSION_INFO);
        TTPlayerConfiger.setValue(0, false);
        TTPlayerConfiger.setValue(1, true);
        TTPlayerConfiger.setValue(2, true);
        TTPlayerConfiger.setValue(3, false);
        TTPlayerConfiger.setValue(4, false);
        TTPlayerConfiger.setValue(5, false);
        TTPlayerConfiger.setValue(6, false);
        TTPlayerConfiger.setValue(7, false);
        TTPlayerConfiger.setValue(8, false);
        TTPlayerConfiger.setValue(10, 0);
        TTPlayerConfiger.setValue(11, false);
        TTPlayerConfiger.setValue(18, 2);
        TTPlayerConfiger.setValue(25, 32);
    }

    static class StringValue
    extends Value {
        private String mValue;

        public StringValue(int key, String value) {
            super(key);
            this.mValue = value;
        }

        public void setValue(String value) {
            this.mValue = value;
        }

        public String getValue() {
            return this.mValue;
        }
    }

    static class LongValue
    extends Value {
        private long mValue;

        public LongValue(int key, long value) {
            super(key);
            this.mValue = value;
        }

        public void setValue(long value) {
            this.mValue = value;
        }

        public long getValue() {
            return this.mValue;
        }
    }

    static final class IntValue
    extends Value {
        private int mValue;

        public IntValue(int key, int value) {
            super(key);
            this.mValue = value;
        }

        public void setValue(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    static class Value {
        private int mKey = -1;

        protected Value(int key) {
            this.mKey = key;
        }

        public int getKey() {
            return this.mKey;
        }
    }
}

