/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.SuppressLint;
import android.util.Log;
import com.ss.ttm.player.ILibraryLoader;
import com.ss.ttm.player.TTPlayerConfiger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class TTPlayerLibraryLoader {
    private static final String TAG = TTPlayerLibraryLoader.class.getSimpleName();
    private static ILibraryLoader mPluginLibLoader;
    private static ILibraryLoader mLibraryLoader;
    private static ILibraryLoader mDebugLibraryLoader;
    private static ILibraryLoader mDefaultLibLoader;
    private static boolean mLibraryLoaded;
    private static boolean IsErrored;
    private static String mErrorInfo;
    private static int mVersion;
    private static final int DEGRADED_VERSION = 2925;

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    private static boolean loadPlayerlibrary(String libName) {
        ArrayList<String> libs;
        String playerLoadPath = null;
        String fullLibName = "lib" + libName + ".so";
        try {
            File file;
            TTPlayerConfiger.setLibraryName(fullLibName);
            TTPlayerConfiger.checkDebugTTPlayerLib();
            playerLoadPath = TTPlayerConfiger.getPlayerLibraryPath();
            if (playerLoadPath != null && !(file = new File(playerLoadPath)).exists()) {
                playerLoadPath = null;
            }
            if (playerLoadPath != null) {
                if (mDebugLibraryLoader != null) {
                    libs = new ArrayList<String>();
                    libs.add(playerLoadPath);
                    Log.d((String)TAG, (String)("load library path = " + playerLoadPath));
                    mDebugLibraryLoader.onLoadNativeLibs(libs);
                } else {
                    System.load(playerLoadPath);
                }
            }
        }
        catch (Throwable e) {
            playerLoadPath = null;
            e.printStackTrace();
            mErrorInfo = "load path library error." + e.toString();
        }
        if (playerLoadPath == null) {
            try {
                libs = new ArrayList();
                libs.add(libName);
                TTPlayerLibraryLoader.loadLibs(libs, true);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("load lib failed name = " + libName));
                return false;
            }
            mErrorInfo = null;
        }
        return true;
    }

    public static final synchronized void loadLibrary() {
        try {
            boolean needDegraded;
            if (mVersion == 0) {
                mVersion = TTPlayerConfiger.getValue(13, 0) / 1000;
            }
            boolean bl = needDegraded = mVersion == 2925;
            if (TTPlayerConfiger.getValue(3, false)) {
                if (!needDegraded) {
                    TTPlayerLibraryLoader.loadPlayerlibrary("ttopenssl");
                    TTPlayerLibraryLoader.loadPlayerlibrary("mffmpeg");
                }
                if (!TTPlayerLibraryLoader.loadPlayerlibrary("ttmplayer")) {
                    IsErrored = true;
                }
            } else {
                ArrayList<String> libs = new ArrayList<String>();
                if (!needDegraded) {
                    libs.add("ttopenssl");
                    libs.add("mffmpeg");
                }
                libs.add("ttmplayer");
                IsErrored = !TTPlayerLibraryLoader.loadLibs(libs, false);
            }
        }
        catch (Throwable e) {
            IsErrored = true;
            e.printStackTrace();
            mErrorInfo = "load default library error." + e.toString();
        }
    }

    public static boolean isError() {
        return IsErrored;
    }

    public static String getErrorInfo() {
        return mErrorInfo;
    }

    public static final void setLibraryLoader(ILibraryLoader loader) {
        mLibraryLoader = loader;
    }

    public static final void setPluginLibraryLoader(ILibraryLoader loader) {
        mPluginLibLoader = loader;
    }

    public static final void setDebugLibraryLoader(ILibraryLoader loader) {
        mDebugLibraryLoader = loader;
    }

    private static boolean loadLibs(List<String> libs, boolean forceLoad) {
        if (!forceLoad & mLibraryLoaded) {
            return mLibraryLoaded;
        }
        if (mLibraryLoader != null) {
            try {
                mLibraryLoaded = mLibraryLoader.onLoadNativeLibs(libs);
            }
            catch (Throwable e) {
                mErrorInfo = e.getMessage();
            }
        } else if (mPluginLibLoader != null) {
            try {
                mLibraryLoaded = mPluginLibLoader.onLoadNativeLibs(libs);
            }
            catch (Throwable e) {
                mErrorInfo = e.getMessage();
            }
        } else {
            mLibraryLoaded = mDefaultLibLoader.onLoadNativeLibs(libs);
        }
        return mLibraryLoaded;
    }

    static {
        mDefaultLibLoader = new DefaultLibraryLoader();
        mLibraryLoaded = false;
        IsErrored = false;
        mErrorInfo = null;
        mVersion = 0;
    }

    private static class DefaultLibraryLoader
    implements ILibraryLoader {
        private DefaultLibraryLoader() {
        }

        @Override
        public boolean onLoadNativeLibs(List<String> list) {
            for (String soName : list) {
                try {
                    System.loadLibrary(soName);
                }
                catch (Throwable e) {
                    mErrorInfo = e.getMessage();
                    Log.d((String)TAG, (String)("load lib failed = " + mErrorInfo));
                    return false;
                }
            }
            return true;
        }
    }
}

