/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.content.Context;
import android.os.RemoteException;
import android.view.Surface;
import com.ss.ttm.player.AudioProcessor;
import com.ss.ttm.player.FrameMetadataListener;
import com.ss.ttm.player.IMediaDataSource;
import com.ss.ttm.player.IPlayerNotifyer;
import com.ss.ttm.player.ITTPlayerRef;
import com.ss.ttm.player.LoadControl;
import com.ss.ttm.player.MaskInfo;
import com.ss.ttm.player.MediaPlayer;
import com.ss.ttm.player.MediaTransport;
import com.ss.ttm.player.SubInfo;
import com.ss.ttm.player.TTPlayer;
import com.ss.ttm.player.TTPlayerClient;
import com.ss.ttm.player.TTPlayerConfiger;
import com.ss.ttm.player.TTPlayerLibraryLoader;

public class TTPlayerRef
extends ITTPlayerRef
implements IPlayerNotifyer {
    private static final String TAG = TTPlayerRef.class.getSimpleName();
    private long mId = System.currentTimeMillis();
    private TTPlayer mPlayer;
    private static String mAppPath = null;
    private static String mLoadErr = null;
    private TTPlayerClient mClient;
    private Context mContext;

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    protected boolean isValid() {
        return this.mPlayer != null;
    }

    @Override
    protected int getLifeId() {
        return this.mPlayer.getIntOption(35, -1);
    }

    public static final synchronized TTPlayerRef create(TTPlayerClient client, Context context) {
        if (mAppPath == null) {
            mAppPath = TTPlayerConfiger.getAppFileCachePath(context);
            try {
                if (TTPlayer.getAppPath() == null) {
                    TTPlayer.setTempFileDir(mAppPath);
                }
            }
            catch (UnsatisfiedLinkError error) {
                mLoadErr = error.getMessage();
            }
        }
        if (mLoadErr != null) {
            throw new UnsatisfiedLinkError(mLoadErr);
        }
        TTPlayerRef player = new TTPlayerRef(context);
        player.mClient = client;
        try {
            player.mPlayer = new TTPlayer(context, player.mId);
            player.mPlayer.setNotifyer(player);
        }
        catch (Throwable e) {
            StringBuffer builder = new StringBuffer();
            String info = "load not error";
            try {
                info = TTPlayerLibraryLoader.getErrorInfo();
            }
            catch (Throwable e1) {
                info = e1.toString();
            }
            builder.append(e.toString()).append(",player:").append(info);
            throw new RuntimeException(builder.toString());
        }
        return player;
    }

    public TTPlayerRef(Context context) {
        this.mContext = context;
    }

    public long getNativeObject() {
        return this.mPlayer.getNativePlayer();
    }

    @Override
    public void prevClose() {
        this.mPlayer.prevClose();
    }

    @Override
    public void close() {
        this.mPlayer.close();
    }

    @Override
    public void release() {
        TTPlayer player = this.mPlayer;
        this.mPlayer = null;
        player.release();
    }

    @Override
    public void start() {
        this.mPlayer.start();
    }

    @Override
    public void pause() {
        this.mPlayer.pause();
    }

    @Override
    public void reset() {
        this.mPlayer.reset();
    }

    @Override
    public void stop() {
        this.mPlayer.stop();
    }

    @Override
    public void prepare() {
        this.mPlayer.prepare();
    }

    @Override
    public void setDataSource(String path) {
        this.mPlayer.setDataSource(path);
    }

    @Override
    protected void setDataSourceFd(int fd) {
        this.mPlayer.setDataSourceFd(fd);
    }

    @Override
    protected void setDataSource(IMediaDataSource mediaDataSource) {
        this.mPlayer.setDataSource(mediaDataSource);
    }

    @Override
    public void setLooping(int b) {
        this.mPlayer.setLooping(b);
    }

    @Override
    public void setVolume(float left, float right) {
        this.mPlayer.setVolume(left, right);
    }

    @Override
    public void mouseEvent(int newAction, int deltaX, int deltaY) {
        this.mPlayer.mouseEvent(newAction, deltaX, deltaY);
    }

    @Override
    public void rotateCamera(float angleX, float angleY) {
        this.mPlayer.rotateCamera(angleX, angleY);
    }

    @Override
    public void seekTo(int msec) {
        this.mPlayer.seekTo(msec);
    }

    @Override
    public int getIntOption(int key, int dValue) {
        return this.mPlayer.getIntOption(key, dValue);
    }

    @Override
    public void setSurface(Surface surface) {
        this.mPlayer.setVideoSurface(surface);
    }

    @Override
    public void setNotifyState(long state) {
        this.mPlayer.setNotifyerState(state);
    }

    @Override
    public int setIntOption(int key, int value) {
        int ret = -1;
        try {
            ret = this.mPlayer.setIntOption(key, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public void setCacheFile(String path, int mode) {
        this.mPlayer.setCacheFile(path, mode);
    }

    @Override
    public int setStringOption(int key, String value) {
        return this.mPlayer.setStringOption(key, value);
    }

    @Override
    public String getStringOption(int key) {
        return this.mPlayer.getStringOption(key);
    }

    @Override
    public int setLongOption(int key, long value) {
        return this.mPlayer.setLongOption(key, value);
    }

    @Override
    public long getLongOption(int key, long dValue) {
        return this.mPlayer.getLongOption(key, dValue);
    }

    @Override
    public void handlePlayerNotify(long id, int lifeId, int what, int parameter, String info) {
        this.mClient.onPlayerNotify(lifeId, what, parameter, info);
    }

    @Override
    public void handleErrorNotify(long id, int type, int errorCode, String logInfo) {
        this.mClient.onPlayLogInfo(type, errorCode, logInfo);
    }

    @Override
    public void takeScreenshot() {
        this.mPlayer.takeScreenshot();
    }

    @Override
    protected void setOnScreenshotListener(MediaPlayer.OnScreenshotListener listener) {
        this.mPlayer.setOnScreenshotListener(listener);
    }

    @Override
    public void switchStream(int bitrate, int streamType) {
        this.mPlayer.switchStream(bitrate, streamType);
    }

    @Override
    protected void setLoadControl(LoadControl control) {
        this.mPlayer.setLoadControl(control);
    }

    @Override
    protected void setMaskInfo(MaskInfo info) {
        this.mPlayer.setMaskInfo(info);
    }

    @Override
    protected void setSubInfo(SubInfo info) {
        this.mPlayer.setSubInfo(info);
    }

    @Override
    protected void setFrameMetadataListener(FrameMetadataListener listener) {
        this.mPlayer.setFrameMetadataListener(listener);
    }

    @Override
    protected void setMediaTransport(MediaTransport transport) {
        this.mPlayer.setMediaTransport(transport);
    }

    @Override
    protected void setAudioProcessor(AudioProcessor processor) {
        this.mPlayer.setAudioProcessor(processor);
    }

    @Override
    protected int setFloatOption(int key, float value) {
        return this.mPlayer.setFloatOption(key, value);
    }

    @Override
    protected int setDoubleOption(int key, double value) {
        return this.mPlayer.setDoubleOption(key, value);
    }

    @Override
    protected float getFloatOption(int key, float dValue) {
        return this.mPlayer.getFloatOption(key, dValue);
    }

    @Override
    protected double getDoubleOption(int key, double dValue) {
        return this.mPlayer.getDoubleOption(key, dValue);
    }

    @Override
    protected Object getObjectOption(int key) {
        return this.mPlayer.getObjectValue(key);
    }
}

