/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.TargetApi;
import android.media.MediaFormat;
import android.util.Log;

public class VendorQTI {
    private static final String TAG = "VendorQTI";
    private static final int LEVEL_LITE = 0;
    private static final int LEVEL_MIDIUM = 1;
    private static final int LEVEL_HIGH = 2;

    @TargetApi(value=16)
    public static void setupVpp(MediaFormat mediaFormat, int level) {
        if (mediaFormat == null) {
            return;
        }
        mediaFormat.setString("vendor.qti-ext-vpp.mode", "HQV_MODE_MANUAL");
        switch (level) {
            case 0: 
            case 1: {
                mediaFormat.setInteger("vendor.qti-ext-vpp-cade.cade-level", level == 0 ? 10 : 20);
                mediaFormat.setInteger("vendor.qti-ext-vpp-aie.ltm-sat-gain", 65);
                mediaFormat.setInteger("vendor.qti-ext-vpp-aie.ltm-sat-offset", 60);
                mediaFormat.setInteger("vendor.qti-ext-vpp-aie.ltm-ace-str", 50);
                break;
            }
            case 2: {
                mediaFormat.setInteger("vendor.qti-ext-vpp-cade.cade-level", 15);
                mediaFormat.setInteger("vendor.qti-ext-vpp-aie.ltm-sat-gain", 70);
                mediaFormat.setInteger("vendor.qti-ext-vpp-aie.ltm-sat-offset", 70);
                mediaFormat.setInteger("vendor.qti-ext-vpp-aie.ltm-ace-str", 50);
                break;
            }
            default: {
                return;
            }
        }
        mediaFormat.setInteger("vendor.qti-ext-vpp-aie.ltm-ace-brightness-low", 20);
        mediaFormat.setInteger("vendor.qti-ext-vpp-aie.ltm-ace-brightness-high", 20);
    }

    public static void debugEffect(MediaFormat mediaFormat) {
        if (mediaFormat == null) {
            return;
        }
        mediaFormat.setInteger("vendor.qti-ext-vpp-demo.process-percent", 50);
        Log.d((String)TAG, (String)("mediaformat = " + mediaFormat.toString()));
    }

    public static void enableLowLatency(MediaFormat mediaFormat) {
        if (mediaFormat == null) {
            return;
        }
        mediaFormat.setInteger("vendor.qti-ext-dec-low-latency.enable", 1);
    }
}

