/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.player;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Choreographer;
import android.view.Display;
import android.view.WindowManager;
import com.ss.ttm.player.CalledByNative;
import com.ss.ttm.player.Keep;
import com.ss.ttm.player.TTPlayer;
import com.ss.ttm.utils.Util;

@Keep
public final class VsyncTimeHelper {
    private static final long TIME_UNSET = -9223372036854775807L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final double DEFAULT_REFRESH_RATE = 16.0;
    private final WindowManager windowManager;
    private final UIVSyncSampler vsyncSampler;
    private final DefaultDisplayListener displayListener;
    private long vsyncDurationNs;

    @CalledByNative
    public VsyncTimeHelper(TTPlayer player) {
        this(player != null ? player.getContext() : null);
    }

    public VsyncTimeHelper(Context context) {
        if (context != null) {
            context = context.getApplicationContext();
            this.windowManager = (WindowManager)context.getSystemService("window");
        } else {
            this.windowManager = null;
        }
        if (this.windowManager != null) {
            this.displayListener = Util.SDK_INT >= 17 ? this.maybeBuildDefaultDisplayListenerV17(context) : null;
            this.vsyncSampler = UIVSyncSampler.getInstance();
        } else {
            this.displayListener = null;
            this.vsyncSampler = null;
        }
        this.vsyncDurationNs = -9223372036854775807L;
    }

    @CalledByNative
    public void enable() {
        if (this.windowManager != null) {
            this.vsyncSampler.addObserver();
            if (this.displayListener != null) {
                this.displayListener.register();
            }
            this.updateDefaultDisplayRefreshRateParams();
        }
    }

    @CalledByNative
    public void disable() {
        if (this.windowManager != null) {
            if (this.displayListener != null) {
                this.displayListener.unregister();
            }
            this.vsyncSampler.removeObserver();
        }
    }

    @CalledByNative
    public long getVsyncDurationNs() {
        return this.vsyncDurationNs;
    }

    @CalledByNative
    public int getUIFps() {
        return this.vsyncSampler.currentUIFps;
    }

    @CalledByNative
    public int getLowestUIFps() {
        return this.vsyncSampler.lowestUIFps;
    }

    @TargetApi(value=17)
    private DefaultDisplayListener maybeBuildDefaultDisplayListenerV17(Context context) {
        DisplayManager manager = (DisplayManager)context.getSystemService("display");
        return manager == null ? null : new DefaultDisplayListener(manager);
    }

    private void updateDefaultDisplayRefreshRateParams() {
        Display defaultDisplay = this.windowManager.getDefaultDisplay();
        if (defaultDisplay != null) {
            double defaultDisplayRefreshRate = defaultDisplay.getRefreshRate();
            this.vsyncDurationNs = (long)(1.0E9 / defaultDisplayRefreshRate);
        } else {
            this.vsyncDurationNs = 62500000L;
        }
        this.vsyncSampler.updateVsyncDuration(this.vsyncDurationNs);
    }

    private static final class UIVSyncSampler
    implements Choreographer.FrameCallback,
    Handler.Callback {
        public volatile long sampledVsyncTimeNs = -9223372036854775807L;
        public volatile long lastSampledVsyncTimeNs = -9223372036854775807L;
        public volatile int skipedFrameCount = 0;
        private long uiVsyncDurationNs;
        private int currentUIFps;
        private int lowestUIFps;
        private long vsyncSampleCount;
        private static final int MSG_ADD_OBSERVER = 0;
        private static final int MSG_REMOVE_OBSERVER = 1;
        private static final int MSG_VSYNC_COMING = 2;
        private static final int MSG_UPDATE_VSYNC_DURATION = 4;
        private static final String BUNDLE_TIMESTAMP = "time";
        private static final String BUNDLE_VSYNC_DURATION = "vsync";
        private static final String TAG = "UIVSyncSampler";
        private static final UIVSyncSampler INSTANCE = new UIVSyncSampler();
        private final Handler mainHandler;
        private final Handler handler;
        private final HandlerThread choreographerOwnerThread = new HandlerThread("Vsync:Handler");
        private Bundle bundle;
        private Choreographer choreographer;
        private int observerCount;

        public static UIVSyncSampler getInstance() {
            return INSTANCE;
        }

        private UIVSyncSampler() {
            this.choreographerOwnerThread.start();
            this.handler = new Handler(this.choreographerOwnerThread.getLooper(), (Handler.Callback)this);
            this.bundle = new Bundle();
            this.mainHandler = new Handler(Looper.getMainLooper());
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    UIVSyncSampler.this.choreographer = Choreographer.getInstance();
                    if (UIVSyncSampler.this.observerCount > 0) {
                        UIVSyncSampler.this.choreographer.postFrameCallback((Choreographer.FrameCallback)INSTANCE);
                    }
                }
            });
        }

        public void addObserver() {
            this.handler.sendEmptyMessage(0);
        }

        public void removeObserver() {
            this.handler.sendEmptyMessage(1);
        }

        public void updateVsyncDuration(long vsyncDuration) {
            this.bundle.putLong(BUNDLE_VSYNC_DURATION, vsyncDuration);
            Message msg = this.handler.obtainMessage(4);
            msg.setData(this.bundle);
            msg.sendToTarget();
        }

        public void doFrame(long uiVsyncTimeNs) {
            Message msg = this.handler.obtainMessage(2);
            this.bundle.putLong(BUNDLE_TIMESTAMP, uiVsyncTimeNs);
            msg.setData(this.bundle);
            msg.sendToTarget();
            this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    this.addObserverInternal();
                    return true;
                }
                case 1: {
                    this.removeObserverInternal();
                    return true;
                }
                case 2: {
                    this.recordUIFps(message.getData().getLong(BUNDLE_TIMESTAMP));
                    return true;
                }
                case 4: {
                    this.updateUIVsyncDurationNs(message.getData().getLong(BUNDLE_VSYNC_DURATION));
                    return true;
                }
            }
            return false;
        }

        private void addObserverInternal() {
            ++this.observerCount;
            if (this.observerCount == 1 && this.choreographer != null) {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }

        private void removeObserverInternal() {
            --this.observerCount;
            if (this.observerCount == 0 && this.choreographer != null) {
                this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
                this.sampledVsyncTimeNs = -9223372036854775807L;
                this.lastSampledVsyncTimeNs = -9223372036854775807L;
                this.skipedFrameCount = 0;
                this.currentUIFps = 0;
                this.lowestUIFps = 0;
                this.vsyncSampleCount = 0L;
            }
        }

        private void updateUIVsyncDurationNs(long refreshRateNs) {
            this.uiVsyncDurationNs = refreshRateNs;
        }

        private void recordUIFps(long vsyncNanoTime) {
            if (this.uiVsyncDurationNs == 0L) {
                return;
            }
            ++this.vsyncSampleCount;
            this.sampledVsyncTimeNs = vsyncNanoTime;
            if (this.lastSampledVsyncTimeNs == -9223372036854775807L) {
                this.lastSampledVsyncTimeNs = this.sampledVsyncTimeNs;
                return;
            }
            long diff = this.sampledVsyncTimeNs - this.lastSampledVsyncTimeNs;
            if (diff <= 0L) {
                this.lastSampledVsyncTimeNs = -9223372036854775807L;
                return;
            }
            int skipped = diff - this.uiVsyncDurationNs > 0L ? Math.round((float)(diff - this.uiVsyncDurationNs) / (float)this.uiVsyncDurationNs) : 0;
            this.skipedFrameCount += skipped;
            this.currentUIFps = (int)(1000000000L / diff);
            this.lowestUIFps = this.lowestUIFps == 0 ? this.currentUIFps : Math.min(this.lowestUIFps, this.currentUIFps);
            this.lastSampledVsyncTimeNs = this.sampledVsyncTimeNs;
        }
    }

    @TargetApi(value=17)
    private final class DefaultDisplayListener
    implements DisplayManager.DisplayListener {
        private final DisplayManager displayManager;

        public DefaultDisplayListener(DisplayManager displayManager) {
            this.displayManager = displayManager;
        }

        public void register() {
            this.displayManager.registerDisplayListener((DisplayManager.DisplayListener)this, null);
        }

        public void unregister() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
        }

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                VsyncTimeHelper.this.updateDefaultDisplayRefreshRateParams();
            }
        }
    }
}

