/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.utils;

import android.content.Context;
import com.ss.ttm.utils.HardWareInfo;
import com.ss.ttm.utils.MemoryInfo;
import com.ss.ttm.utils.VersionInfo;
import java.util.Locale;

public class AVErrorInfo {
    private static StringBuilder PHONE_INFO;
    public static final String ERROR = "error";
    public static final String CRASH = "crash";

    public static final void setupPhoneInfo(Context context, StringBuilder builder) {
        long[] memory;
        String[] versions = VersionInfo.getVersion();
        if (versions != null) {
            builder.append(String.format("version:%s,%s,%s\r\n", versions[0], versions[1], versions[2])).append("\r\n");
        }
        if ((memory = MemoryInfo.getRomMemroy()) != null) {
            builder.append(String.format(Locale.US, "rom memory totle:%d,availe:%d\r\n", memory[0], memory[1])).append("\r\n");
        }
        long ramAvail = MemoryInfo.getAvailMemory(context);
        long ramTotal = MemoryInfo.getTolalMemory();
        builder.append(String.format(Locale.US, "ram memory totle:%d,availe:%d\r\n", ramTotal, ramAvail)).append("\r\n");
        long[] sdcardSize = HardWareInfo.getSDCardSize(context);
        if (sdcardSize != null) {
            builder.append(String.format(Locale.US, "sdcard totle:%d,availe:%d\r\n", sdcardSize[0], sdcardSize[1])).append("\r\n");
        }
    }

    public static void setupErrorInfo(Context context, StringBuilder logInfo, String errName, String errorInfo, String url) {
        if (PHONE_INFO == null) {
            PHONE_INFO = new StringBuilder();
            AVErrorInfo.setupPhoneInfo(context, PHONE_INFO);
        }
        logInfo.append((CharSequence)PHONE_INFO);
        logInfo.append("\r\n").append(errName).append(":").append(errorInfo);
    }
}

