/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.utils;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

public class HardWareInfo {
    public static final int CPU_FAMILY_UNKNOWN = 0;
    public static final int CPU_FAMILY_ARM = 1;
    public static final int CPU_FAMILY_X86 = 2;
    public static final int CPU_FAMILY_MIPS = 3;
    private static int mCpuType = 0;
    private static int[] mArmArchitecture = new int[3];
    private static final int NEON = 0;
    private static final int ATOM = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getCpuInfo() {
        block12: {
            try {
                FileInputStream is = new FileInputStream("/proc/cpuinfo");
                InputStreamReader ir = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(ir);
                try {
                    String nameProcessor = "processor";
                    String nameFeatures = "features";
                    String nameModel = "model name";
                    while (true) {
                        String line = br.readLine();
                        String[] pair = null;
                        if (line == null) {
                            break block12;
                        }
                        pair = (line = line.replaceAll("\t", "").toLowerCase(Locale.US)).split(":");
                        if (pair.length != 2) continue;
                        String key = pair[0].trim();
                        String val = pair[1].trim();
                        if (val == null || key == null) continue;
                        if (key.compareTo(nameProcessor) == 0) {
                            if (val.contains("armv") || val.contains("aarch64")) {
                                HardWareInfo.mArmArchitecture[0] = 1;
                            } else {
                                if (!val.contains("intel")) continue;
                                HardWareInfo.mArmArchitecture[0] = 2;
                            }
                            break block12;
                        }
                        if (key.compareToIgnoreCase(nameFeatures) == 0) {
                            if (!val.contains("neon") && !val.contains("thumb") && !val.contains("vfpv") && !val.contains("asimd") && !val.contains("simd")) continue;
                            HardWareInfo.mArmArchitecture[0] = 1;
                            continue;
                        }
                        if (key.compareToIgnoreCase(nameModel) != 0) continue;
                        if (val.contains("intel")) {
                            HardWareInfo.mArmArchitecture[0] = 2;
                            break block12;
                        }
                        if (val.contains("arm")) break;
                    }
                    HardWareInfo.mArmArchitecture[0] = 1;
                }
                finally {
                    br.close();
                    ir.close();
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mArmArchitecture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getCpuArchitecture() {
        try {
            FileInputStream is = new FileInputStream("/proc/cpuinfo");
            InputStreamReader ir = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(ir);
            try {
                String nameProcessor = "Processor";
                String nameFeatures = "Features";
                String nameModel = "model name";
                String nameCpuFamily = "cpu family";
                while (true) {
                    String line = br.readLine();
                    String[] pair = null;
                    if (line == null) {
                        break;
                    }
                    pair = (line = line.replace("\t", "")).split(":");
                    if (pair.length != 2) continue;
                    String key = pair[0].trim();
                    String val = pair[1].trim();
                    if (key.compareTo(nameProcessor) == 0) {
                        String temp;
                        StringBuilder n = new StringBuilder();
                        for (int i = val.indexOf("ARMv") + 4; i < val.length() && (temp = val.charAt(i) + "").matches("\\d"); ++i) {
                            n.append(temp);
                        }
                        HardWareInfo.mArmArchitecture[0] = 1;
                        HardWareInfo.mArmArchitecture[1] = Integer.parseInt(n.toString());
                        continue;
                    }
                    if (key.compareToIgnoreCase(nameFeatures) == 0) {
                        if (!val.contains("neon")) continue;
                        HardWareInfo.mArmArchitecture[2] = 0;
                        continue;
                    }
                    if (key.compareToIgnoreCase(nameModel) == 0) {
                        if (!val.contains("Intel")) continue;
                        HardWareInfo.mArmArchitecture[0] = 2;
                        HardWareInfo.mArmArchitecture[2] = 1;
                        continue;
                    }
                    if (key.compareToIgnoreCase(nameCpuFamily) != 0) continue;
                    HardWareInfo.mArmArchitecture[1] = Integer.parseInt(val);
                }
            }
            finally {
                br.close();
                ir.close();
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mArmArchitecture;
    }

    private static boolean isAndroidJB2() {
        return Build.VERSION.SDK_INT >= 18;
    }

    private static long getDirectoryAvailableSize(String path) {
        try {
            long availableBlocks;
            long blockSize;
            StatFs stat = new StatFs(path);
            if (HardWareInfo.isAndroidJB2()) {
                blockSize = stat.getBlockSizeLong();
                availableBlocks = stat.getAvailableBlocksLong();
            } else {
                blockSize = stat.getBlockSize();
                availableBlocks = stat.getAvailableBlocks();
            }
            return blockSize * availableBlocks;
        }
        catch (IllegalArgumentException var6) {
            return -1L;
        }
    }

    private static long getDirectoryTotalSize(String path) {
        try {
            long totalBlocks;
            long blockSize;
            StatFs stat = new StatFs(path);
            if (HardWareInfo.isAndroidJB2()) {
                blockSize = stat.getBlockSizeLong();
                totalBlocks = stat.getBlockCountLong();
            } else {
                blockSize = stat.getBlockSize();
                totalBlocks = stat.getBlockCount();
            }
            return blockSize * totalBlocks;
        }
        catch (IllegalArgumentException var6) {
            return -1L;
        }
    }

    private static long getTotalStorageSize(Context context) {
        if (context == null) {
            return -1L;
        }
        return Environment.getDataDirectory() != null ? HardWareInfo.getDirectoryTotalSize(context.getFilesDir().getParent()) : -1L;
    }

    private static long getAvailableStorageSize(Context context) {
        if (context == null) {
            return -1L;
        }
        return Environment.getDataDirectory() != null ? HardWareInfo.getDirectoryAvailableSize(context.getFilesDir().getParent()) : -1L;
    }

    public static long[] getSDCardSize(Context context) {
        long[] sdCardInfo = new long[2];
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            long total;
            long avail = HardWareInfo.getAvailableStorageSize(context);
            sdCardInfo[0] = total = HardWareInfo.getTotalStorageSize(context);
            sdCardInfo[1] = avail;
        }
        return sdCardInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getProcessCpuInfo() {
        String[] cpuInfos;
        BufferedReader reader = null;
        try {
            int pid = Process.myPid();
            reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + pid + "/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
        }
        catch (IOException e) {
            long l = 0L;
            return l;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long appCpuTime = 0L;
        try {
            appCpuTime = Long.parseLong(cpuInfos[13]) + Long.parseLong(cpuInfos[14]) + Long.parseLong(cpuInfos[15]) + Long.parseLong(cpuInfos[16]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0L;
        }
        return appCpuTime;
    }

    public static int getCpuFamily() {
        if (mCpuType == 0) {
            HardWareInfo.getCpuInfo();
            mCpuType = mArmArchitecture[0];
        }
        return mCpuType;
    }
}

