/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttm.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class MemoryInfo {
    private static long[] mRomMemroy;
    private static long mTotalMemorySize;

    public static long[] getRomMemroy() {
        if (mRomMemroy == null) {
            long[] romInfo = new long[2];
            romInfo[0] = MemoryInfo.getTotalInternalMemorySize();
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long availableBlocks = stat.getAvailableBlocks();
            romInfo[1] = blockSize * availableBlocks;
            mRomMemroy = romInfo;
        }
        return mRomMemroy;
    }

    public static long getTotalInternalMemorySize() {
        if (mTotalMemorySize == 0L) {
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long totalBlocks = stat.getBlockCount();
            mTotalMemorySize = totalBlocks * blockSize;
        }
        return mTotalMemorySize;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return mi.availMem / 1024L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTolalMemory() {
        String path = "/proc/meminfo";
        String content = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(path), 8);
            String line = br.readLine();
            if (line != null) {
                content = line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        int begin = content.indexOf(58);
        int end = content.indexOf(107);
        content = content.substring(begin + 1, end).trim();
        long mTotal = Integer.parseInt(content);
        return mTotal;
    }

    static {
        mTotalMemorySize = 0L;
    }
}

