package com.cloud.hisavana.net;


import com.cloud.sdk.commonutil.gsonutil.GsonUtil;

import java.util.HashMap;
import java.util.Map;

import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

/**
 * 公共入参
 *
 * @author chenshijun
 */

public class CommonRequest {

    /**
     * 创建Get请求的Request
     */
    public static Request createGetRequest(String url, RequestParams params) {
        StringBuilder urlBuilder = new StringBuilder(url).append("?");

        if (params != null && !params.getHttpParams().isEmpty()) {
            for (Map.Entry<String, String> entry : params.getHttpParams().entrySet()) {
                urlBuilder.append(entry.getKey())
                        .append("=")
                        .append(entry.getValue())
                        .append("&");
            }
        }

        return new Request.Builder().url(urlBuilder.substring(0, urlBuilder.length() - 1))
                .get().build();
    }

    /**
     * 创建Post请求的Request
     *
     * @return 返回一个创建好的Request对象
     */
    public static Request createPostRequest(String url, RequestParams params) {
        Request request = new Request.Builder()
                .url(url)
                .headers(getHeaders(params.getHttpParams()))
                .post(getJSONBody(params.getPostBody()))
                .build();

        return request;
    }

    /**
     * 返回RequestBody对象
     */
    private static RequestBody getRawBody(String content, MediaType type) {
        return RequestBody.create(type, content);
    }

    /**
     * Content-Type: application/json
     */
    private static RequestBody getJSONBody(Object json) {
        return getRawBody(GsonUtil.toJson(json), MediaType.parse(ContentType.JSON.toString()));
    }

    /**
     * 得到网络请求的Headers
     */
    private static Headers getHeaders(Map<String, String> headerMaps) {
        Map headers = headerMaps;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }

        if (!headers.isEmpty()) {
            return Headers.of(headers);
        }
        return new Headers.Builder().build();
    }
}
