package com.cloud.hisavana.net

import com.cloud.hisavana.net.impl.IHttpCallback
import com.cloud.hisavana.net.disklrucache.listener.LruCleanCallBack
import java.util.concurrent.CopyOnWriteArrayList

/**
 * 所有的请求接口
 *
 * @author chenshijun
 */
object HttpRequest {

    /** LRU清理的监听 */
    val lruCleanCallBacks: CopyOnWriteArrayList<LruCleanCallBack> = CopyOnWriteArrayList<LruCleanCallBack>()
    /** 在线广告的缓存大小 */
    var cacheSize = 0
    /** 离线广告的缓存大小 */
    var offlineCacheSize = 0

    /**
     * GET请求
     *
     * @param url      URL请求地址
     * @param params   入参
     * @param callback 回调接口
     */
    fun getRequest(url: String?, params: RequestParams?, callback: IHttpCallback?) {
        CommonOkHttpClient.get(CommonRequest.createGetRequest(url, params), null)
    }

    @JvmStatic
    fun postRequest(
        url: String?, params: RequestParams?,
        callback: IHttpCallback?
    ) {
        CommonOkHttpClient.post(params, CommonRequest.createPostRequest(url, params), callback)
    }

    /**
     * 下载图片
     *
     * @param url 下载地址
     * @param params   入参
     * @param callback 回调接口
     */
    @JvmStatic
    fun downloadImage(
        url: String?,
        params: RequestParams,
        callback: IHttpCallback?
    ) {
        CommonOkHttpClient.downLoadImg(
            params,
            CommonRequest.createGetRequest(url, params),
            callback
        )
    }

    /**
     * 添加LRU清理的监听
     */
    fun addLruCleanCallBack(lruCleanCallBack: LruCleanCallBack?) {
        if (lruCleanCallBack == null) {
            return
        }
        lruCleanCallBacks.add(lruCleanCallBack)
    }

    /**
     * 删除LRU清理的监听
     */
    fun clearLruCleanCallBack(lruCleanCallBack: LruCleanCallBack?) {
        if (lruCleanCallBack == null || lruCleanCallBacks.isEmpty()) {
            return
        }
        lruCleanCallBacks.remove(lruCleanCallBack)
    }
}