package com.cloud.hisavana.net

import java.util.concurrent.ConcurrentHashMap

/**
 * 请求参数
 *
 * @author chenshijun
 */
class RequestParams {
    /** 请求body  */
    var postBody: Any = ""
        set(body) {
            if (body != null) {
                field = body
            }
        }

    /**  线程安全的HashMap  */
    val httpParams = ConcurrentHashMap<String, String>()
    /** 是否需要返回物料路径 */
    var isFetchFilePath = false
    /** 是否使用cache */
    var isUseCache = true
    /** 是否使用离线缓存库 */
    var isSwitchOffLineCache = false

    /**
     * Adds a key/value string pair to the request.
     */
    fun put(key: String?, value: String?) {
        if (key != null && value != null) {
            httpParams[key] = value
        }
    }

    fun putHeads(key: String?, value: String?) {
        if (key != null && value != null) {
            httpParams[key] = value
        }
    }
}