package com.cloud.hisavana.net.disklrucache.impl;


/**
 * 构建DiskLruCache
 */
public class DiskLruCacheFactory implements IDiskCache.Factory {

    private final long diskCacheSize;
    private final boolean isSwitchOffLineCache;

    public DiskLruCacheFactory(long cacheMaxSize, boolean isSwitchOffLineCache) {
        this.diskCacheSize = cacheMaxSize;
        this.isSwitchOffLineCache = isSwitchOffLineCache;
    }

    @Override
    public IDiskCache build() {
        return new DiskCacheImpl(null, diskCacheSize, isSwitchOffLineCache);
    }
}
