package com.cloud.hisavana.net.interceptor;

import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.cloud.hisavana.net.constants.HttpCode;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * 处理重定向的拦截器
 *
 * @author chenshijun
 */
public class RedirectInterceptor implements Interceptor {
    @NonNull
    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        int code = response.code();
        if (code == HttpCode.REDIRECT_301 || code == HttpCode.REDIRECT_302) {
            //获取重定向的地址
            String location = response.headers().get("Location");
            if (!TextUtils.isEmpty(location)) {
                //重新构建请求
                response.close();
                Request newRequest = request.newBuilder().url(location).build();
                response = chain.proceed(newRequest);
            }
        }
        return response;
    }
}
