package com.cloud.hisavana.net.interceptor;

import android.util.Log;

import androidx.annotation.NonNull;

import com.cloud.hisavana.net.CommonOkHttpClient;
import com.cloud.sdk.commonutil.util.CommonLogUtil;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * 日志拦截器
 *
 * @author chenshijun
 */
public class RequestInterceptor implements Interceptor {
    @NonNull
    @Override
    public Response intercept(@NonNull Chain chain) throws IOException {
        Request request = chain.request()
                .newBuilder()
                .build();
        if (Log.isLoggable(CommonOkHttpClient.TAG, Log.DEBUG)) {
            CommonLogUtil.netLog("requestUrl=" + request.url());
            CommonLogUtil.netLog("[request-headers]:" + request.headers());
        }
        long startNs = System.nanoTime();
        Response response = chain.proceed(request);
        long costMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        if (Log.isLoggable(CommonOkHttpClient.TAG, Log.DEBUG)) {
            CommonLogUtil.netLog("[costs]:" + costMs + "ms");
            CommonLogUtil.netLog("[response-code]:" + response.code());
        }
        return response;
    }
}
