/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net;

import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.net.RequestParams;
import com.cloud.hisavana.net.disklrucache.ImageCacheURL;
import com.cloud.hisavana.net.disklrucache.impl.IDiskCache;
import com.cloud.hisavana.net.disklrucache.utils.DiskLruCacheUtil;
import com.cloud.hisavana.net.impl.IHttpCallback;
import com.cloud.hisavana.net.interceptor.RedirectInterceptor;
import com.cloud.hisavana.net.interceptor.RequestInterceptor;
import com.cloud.hisavana.net.utils.ByteBufferUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsin.networkmonitor.MonitorFactory;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class CommonOkHttpClient {
    public static final String TAG = "ADSDK";
    private static final int TIME_OUT = 30;
    public static boolean isTestRequest = false;

    public static OkHttpClient getOkHttpClient() {
        return GeneralOkHttpClient.commonOkHttpClient;
    }

    public static OkHttpClient getImageOkHttpClient() {
        return ImageOkHttpClient.imageOkHttpClient;
    }

    public static Call sendRequest(Request request, Callback commonCallback) {
        Call call = CommonOkHttpClient.getOkHttpClient().newCall(request);
        call.enqueue(commonCallback);
        return call;
    }

    public static Call get(Request request, Callback callback) {
        Call call = CommonOkHttpClient.getOkHttpClient().newCall(request);
        call.enqueue(callback);
        return call;
    }

    public static Call post(RequestParams params, final Request request, final IHttpCallback callback) {
        if (callback != null) {
            callback.sendStartMessage();
        }
        Call call = CommonOkHttpClient.getOkHttpClient().newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                try {
                    if (callback != null) {
                        if (e instanceof SocketTimeoutException) {
                            callback.sendFailureMessage(481, null, e);
                        } else if (e instanceof UnknownHostException) {
                            callback.sendFailureMessage(484, null, e);
                        } else if (e instanceof NoRouteToHostException) {
                            callback.sendFailureMessage(485, null, e);
                        } else if (e instanceof ProtocolException) {
                            callback.sendFailureMessage(486, null, e);
                        } else if (e instanceof ConnectException) {
                            callback.sendFailureMessage(483, null, e);
                        } else {
                            callback.sendFailureMessage(480, null, e);
                        }
                    }
                }
                catch (Exception exception) {
                    CommonLogUtil.netLog((String)("onFailure:  " + Log.getStackTraceString((Throwable)exception)));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                block6: {
                    try {
                        if (callback != null && response != null) {
                            byte[] body = response.body().bytes();
                            if (body != null && body.length > 0 && callback != null) {
                                callback.sendResponseMessage(response.code(), body, request.headers());
                            }
                        } else if (callback != null) {
                            callback.sendFailureMessage(1027, null, new Exception("http response body is empty"));
                        }
                    }
                    catch (Exception e) {
                        if (callback == null || response == null) break block6;
                        callback.sendFailureMessage(response.code(), null, e);
                    }
                }
            }
        });
        return call;
    }

    public static Call downLoadImg(RequestParams params, Request request, IHttpCallback callback) {
        block8: {
            if (Log.isLoggable((String)TAG, (int)3)) {
                CommonLogUtil.netLog((String)("downLoadImg okhttp------> run Current Looper:" + (Looper.myLooper() == Looper.getMainLooper() ? "Main Looper" : "thread Looper")));
            }
            boolean isFromCache = false;
            try {
                IDiskCache diskCache;
                if (!params.isUseCache() || (diskCache = DiskLruCacheUtil.getDiskCache(params.isSwitchOffLineCache())) == null) break block8;
                File imageFile = diskCache.get(new ImageCacheURL(request.url().toString()));
                if (imageFile != null && imageFile.exists() && imageFile.length() > 0L) {
                    isFromCache = true;
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        CommonLogUtil.netLog((String)("image url:" + request.url()));
                        CommonLogUtil.netLog((String)("image path:" + imageFile.getPath()));
                    }
                    if (callback != null) {
                        if (params.isFetchFilePath()) {
                            callback.sendResponseMessage(250, ByteBufferUtil.toBytes(ByteBufferUtil.fromFile(imageFile)), imageFile.getPath());
                        } else {
                            callback.sendResponseMessage(250, ByteBufferUtil.toBytes(ByteBufferUtil.fromFile(imageFile)));
                        }
                        return null;
                    }
                    break block8;
                }
                return CommonOkHttpClient.realDownLoadImage(params, request, callback);
            }
            catch (IOException e) {
                CommonLogUtil.netLog((String)("downLoadImg: --> " + Log.getStackTraceString((Throwable)e)));
                if (callback == null || !isFromCache) break block8;
                callback.sendFailureMessage(256, null, e);
            }
        }
        return CommonOkHttpClient.realDownLoadImage(params, request, callback);
    }

    private static Call realDownLoadImage(final RequestParams params, final Request request, final IHttpCallback callback) {
        Call call = CommonOkHttpClient.getImageOkHttpClient().newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                try {
                    if (callback != null) {
                        if (e instanceof SocketTimeoutException) {
                            callback.sendFailureMessage(481, null, e);
                        } else if (e instanceof UnknownHostException) {
                            callback.sendFailureMessage(484, null, e);
                        } else if (e instanceof NoRouteToHostException) {
                            callback.sendFailureMessage(485, null, e);
                        } else if (e instanceof ProtocolException) {
                            callback.sendFailureMessage(486, null, e);
                        } else if (e instanceof ConnectException) {
                            callback.sendFailureMessage(483, null, e);
                        } else {
                            callback.sendFailureMessage(480, null, e);
                        }
                    }
                }
                catch (Exception exception) {
                    CommonLogUtil.netLog((String)("onFailure:  " + Log.getStackTraceString((Throwable)exception)));
                }
            }

            public void onResponse(Call call, Response response) {
                block13: {
                    try {
                        if (callback != null && response != null) {
                            byte[] body = response.body().bytes();
                            if (body != null && body.length > 0) {
                                if (!params.isFetchFilePath()) {
                                    callback.sendResponseMessage(response.code(), body, request.headers());
                                }
                                String filePath = CommonOkHttpClient.cacheToDisk(params, request.url().toString(), response.code(), body);
                                if (Log.isLoggable((String)CommonOkHttpClient.TAG, (int)3)) {
                                    CommonLogUtil.netLog((String)("onResponse: url = " + request.url() + " , code = " + response.code() + " , filePath = " + filePath));
                                }
                                if (params.isFetchFilePath() && callback != null) {
                                    if (CommonOkHttpClient.isFilePathExist(filePath)) {
                                        callback.sendResponseMessage(response.code(), body, filePath);
                                    } else {
                                        callback.sendFailureMessage(1026, null, new Exception("fail to cache file to disk"));
                                    }
                                }
                            } else {
                                callback.sendFailureMessage(1027, null, new Exception("http response body is empty"));
                            }
                        } else if (callback != null) {
                            callback.sendFailureMessage(1027, null, new Exception("http response body is empty"));
                        }
                    }
                    catch (Exception e) {
                        if (callback == null || response == null) break block13;
                        callback.sendFailureMessage(response.code(), null, e);
                    }
                }
                if (callback != null) {
                    callback.sendFinishMessage();
                }
            }
        });
        return call;
    }

    private static String cacheToDisk(RequestParams params, String url, int code, byte[] buf) {
        String filePath = "";
        try {
            IDiskCache diskCache = DiskLruCacheUtil.getDiskCache(params.isSwitchOffLineCache());
            if (params.isUseCache() && diskCache != null && code < 300) {
                filePath = diskCache.put(new ImageCacheURL(url), buf);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    CommonLogUtil.netLog((String)("url :" + url + " , write cache finish.  filePath = " + filePath));
                }
            }
        }
        catch (Exception e) {
            CommonLogUtil.netLog((String)("cacheToDisk is failure, " + Log.getStackTraceString((Throwable)e)));
        }
        return filePath;
    }

    private static boolean isFilePathExist(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.length() > 0L;
    }

    private static class ImageOkHttpClient {
        private static final OkHttpClient imageOkHttpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).followRedirects(false).addInterceptor((Interceptor)new RedirectInterceptor()).addInterceptor((Interceptor)new RequestInterceptor()).eventListenerFactory((EventListener.Factory)new MonitorFactory(null, 1, isTestRequest)).build();

        private ImageOkHttpClient() {
        }
    }

    private static class GeneralOkHttpClient {
        private static final OkHttpClient commonOkHttpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).followRedirects(false).addInterceptor((Interceptor)new RedirectInterceptor()).addInterceptor((Interceptor)new RequestInterceptor()).eventListenerFactory((EventListener.Factory)new MonitorFactory(null, 0, isTestRequest)).build();

        private GeneralOkHttpClient() {
        }
    }
}

