/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net;

import com.cloud.hisavana.net.ContentType;
import com.cloud.hisavana.net.RequestParams;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CommonRequest {
    public static Request createGetRequest(String url, RequestParams params) {
        StringBuilder urlBuilder = new StringBuilder(url).append("?");
        if (params != null && !params.getHttpParams().isEmpty()) {
            for (Map.Entry<String, String> entry : params.getHttpParams().entrySet()) {
                urlBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
        }
        return new Request.Builder().url(urlBuilder.substring(0, urlBuilder.length() - 1)).get().build();
    }

    public static Request createPostRequest(String url, RequestParams params) {
        Request request = new Request.Builder().url(url).headers(CommonRequest.getHeaders(params.getHttpParams())).post(CommonRequest.getJSONBody(params.getPostBody())).build();
        return request;
    }

    private static RequestBody getRawBody(String content, MediaType type) {
        return RequestBody.create((MediaType)type, (String)content);
    }

    private static RequestBody getJSONBody(Object json) {
        return CommonRequest.getRawBody(GsonUtil.toJson((Object)json), MediaType.parse((String)ContentType.JSON.toString()));
    }

    private static Headers getHeaders(Map<String, String> headerMaps) {
        Map<String, String> headers = headerMaps;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        if (!headers.isEmpty()) {
            return Headers.of(headers);
        }
        return new Headers.Builder().build();
    }
}

