/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.disklrucache;

import android.net.Uri;
import android.text.TextUtils;
import com.cloud.hisavana.net.utils.MD5;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ImageCacheURL {
    private static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    private volatile byte[] cacheKeyBytes;
    private final String safeStringUrl;
    private String originUrl;
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public ImageCacheURL(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new NullPointerException("url must be can not null or empty");
        }
        this.originUrl = url;
        this.safeStringUrl = Uri.encode((String)url, (String)ALLOWED_URI_CHARS);
    }

    public String getKey() {
        return this.toMD5();
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImageCacheURL) {
            ImageCacheURL other = (ImageCacheURL)obj;
            return this.getKey().equals(other.getKey());
        }
        return false;
    }

    public String toMD5() {
        return MD5.MD5Encode(this.safeStringUrl);
    }

    public byte[] getCacheKeyBytes() {
        if (this.cacheKeyBytes == null) {
            this.cacheKeyBytes = this.safeStringUrl.getBytes(CHARSET);
        }
        return this.cacheKeyBytes;
    }

    public int hashCode() {
        int hashCode = this.safeStringUrl.hashCode();
        hashCode = 31 * hashCode;
        return hashCode;
    }
}

