/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.impl;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.cloud.hisavana.net.impl.IHttpCallback;
import com.cloud.hisavana.net.utils.CheckUtil;
import java.io.IOException;
import okhttp3.Headers;

public abstract class HttpCallbackImpl
implements IHttpCallback {
    private static final String LOG_TAG = "HttpCallbackImpl";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String UTF8_BOM = "\ufeff";
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 2;
    protected static final int FINISH_MESSAGE = 3;
    protected static final int PAUSE_MESSAGE = 7;
    private Handler handler;
    private boolean useSyncMode;
    private boolean usePoolThread;
    private Looper looper = null;

    public HttpCallbackImpl() {
        this(null);
    }

    public HttpCallbackImpl(Looper looper) {
        this(looper == null ? Looper.myLooper() : looper, false);
    }

    public HttpCallbackImpl(boolean usePool) {
        this(usePool ? null : Looper.myLooper(), usePool);
    }

    private HttpCallbackImpl(Looper looper, boolean usePool) {
        if (!usePool) {
            CheckUtil.asserts(looper != null, "use looper thread, must call Looper.prepare() first!");
            this.looper = looper;
            this.handler = new ResponderHandler(this, looper);
        } else {
            CheckUtil.asserts(looper == null, "use pool thread, looper should be null!");
            this.looper = null;
            this.handler = null;
        }
        this.usePoolThread = usePool;
    }

    @Override
    public void setUseSyncMode(boolean useSyncMode) {
        if (!useSyncMode && this.looper == null) {
            useSyncMode = true;
            Log.w((String)LOG_TAG, (String)"Current thread has not called Looper.prepare(). Forcing synchronous mode.");
        }
        if (!useSyncMode && this.handler == null) {
            this.handler = new ResponderHandler(this, this.looper);
        } else if (useSyncMode && this.handler != null) {
            this.handler = null;
        }
        this.useSyncMode = useSyncMode;
    }

    @Override
    public boolean getUseSyncMode() {
        return this.useSyncMode;
    }

    @Override
    public boolean getUsePoolThread() {
        return this.usePoolThread;
    }

    @Override
    public void setUsePoolThread(boolean usePoolThread) {
        if (usePoolThread) {
            this.looper = null;
            this.handler = null;
        }
        this.usePoolThread = usePoolThread;
    }

    public abstract void onSuccess(int var1, byte[] var2);

    public void onSuccess(int statusCode, byte[] responseBody, String filePath) {
    }

    public void onResponseHeader(Headers responseHeaders) {
    }

    public abstract void onFailure(int var1, byte[] var2, Throwable var3);

    @Override
    public void sendSuccessMessage(int statusCode, byte[] responseBody) {
        this.sendMessage(this.obtainMessage(0, new Object[]{statusCode, responseBody}));
    }

    @Override
    public void sendSuccessMessage(int statusCode, byte[] responseBody, String filePath) {
        this.sendMessage(this.obtainMessage(0, new Object[]{statusCode, responseBody, filePath}));
    }

    @Override
    public void sendSuccessMessage(int statusCode, byte[] responseBody, Headers requestHeaders) {
        this.sendMessage(this.obtainMessage(0, new Object[]{statusCode, responseBody, requestHeaders}));
    }

    @Override
    public void sendFailureMessage(int statusCode, byte[] responseBody, Throwable error) {
        this.sendMessage(this.obtainMessage(1, new Object[]{statusCode, responseBody, error}));
    }

    @Override
    public void sendFailureMessage(int statusCode, byte[] responseBody, Throwable error, Headers requestHeaders) {
        this.sendMessage(this.obtainMessage(1, new Object[]{statusCode, responseBody, error, requestHeaders}));
    }

    @Override
    public void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    @Override
    public void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    @Override
    public void sendPauseMessage() {
        this.sendMessage(this.obtainMessage(7, null));
    }

    protected void postRunnable(Runnable runnable) {
        if (runnable != null) {
            if (this.getUseSyncMode() || this.handler == null) {
                runnable.run();
            } else {
                this.handler.post(runnable);
            }
        }
    }

    protected Message obtainMessage(int msgId, Object msgData) {
        return Message.obtain((Handler)this.handler, (int)msgId, (Object)msgData);
    }

    protected void sendMessage(Message msg) {
        if (this.getUseSyncMode() || this.handler == null) {
            this.handleMessage(msg);
        } else if (!Thread.currentThread().isInterrupted() && this.handler != null) {
            this.handler.sendMessage(msg);
        }
    }

    protected void handleMessage(Message message) {
        try {
            switch (message.what) {
                case 0: {
                    Object[] response = (Object[])message.obj;
                    if (response != null && response.length >= 2) {
                        if (response.length >= 3) {
                            if (response[2] instanceof String) {
                                this.onSuccess((Integer)response[0], (byte[])response[1], (String)response[2]);
                                break;
                            }
                            if (response[2] instanceof Headers) {
                                this.onResponseHeader((Headers)response[2]);
                                this.onSuccess((Integer)response[0], (byte[])response[1]);
                            }
                            break;
                        }
                        this.onSuccess((Integer)response[0], (byte[])response[1]);
                        break;
                    }
                    Log.e((String)LOG_TAG, (String)"SUCCESS_MESSAGE didn't got enough params");
                    break;
                }
                case 1: {
                    Object[] response = (Object[])message.obj;
                    if (response != null && response.length >= 3) {
                        if (response.length >= 4 && response[3] instanceof Headers) {
                            this.onResponseHeader((Headers)response[3]);
                        }
                        this.onFailure((Integer)response[0], (byte[])response[1], (Throwable)response[2]);
                        break;
                    }
                    Log.e((String)LOG_TAG, (String)"FAILURE_MESSAGE didn't got enough params");
                    break;
                }
                case 2: {
                    this.onStart();
                    break;
                }
                case 3: {
                    this.onFinish();
                    break;
                }
                case 7: {
                    this.onPause();
                    break;
                }
                default: {
                    Log.e((String)LOG_TAG, (String)"UnKnown message");
                    break;
                }
            }
        }
        catch (Throwable error) {
            this.onUserException(error);
        }
    }

    @Override
    public void sendResponseMessage(int code, byte[] responseBody) {
        if (!Thread.currentThread().isInterrupted()) {
            if (code >= 300) {
                this.sendFailureMessage(code, responseBody, new IOException());
            } else {
                this.sendSuccessMessage(code, responseBody);
            }
        }
    }

    @Override
    public void sendResponseMessage(int code, byte[] responseBody, String filePath) {
        if (!Thread.currentThread().isInterrupted()) {
            if (code >= 300) {
                this.sendFailureMessage(code, responseBody, new IOException());
            } else {
                this.sendSuccessMessage(code, responseBody, filePath);
            }
        }
    }

    @Override
    public void sendResponseMessage(int code, byte[] responseBody, Headers requestHeaders) {
        if (!Thread.currentThread().isInterrupted()) {
            if (code >= 300) {
                this.sendFailureMessage(code, responseBody, new IOException(), requestHeaders);
            } else {
                this.sendSuccessMessage(code, responseBody, requestHeaders);
            }
        }
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    public void onPause() {
        Log.d((String)LOG_TAG, (String)"Request got onPaused");
    }

    public void onUserException(Throwable error) {
        Log.e((String)LOG_TAG, (String)"User-space exception detected!", (Throwable)error);
        throw new RuntimeException(error);
    }

    private static class ResponderHandler
    extends Handler {
        private final HttpCallbackImpl httpCallback;

        ResponderHandler(HttpCallbackImpl callback, Looper looper) {
            super(looper);
            this.httpCallback = callback;
        }

        public void handleMessage(Message msg) {
            this.httpCallback.handleMessage(msg);
        }
    }
}

