/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.utils;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.transsion.core.utils.Commutil;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String INDIVIDUAL_DIR_NAME = "ad-images";
    private static final String OFFLINE_CACHE = "offline_cache";
    private static final String NORMAL_CACHE = "hisavana_net_cache";
    private static final String TAG = "StorageUtils";

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        return StorageUtils.getCacheDirectory(context, true);
    }

    public static File getCacheDirectory(Context context, boolean preferExternal) {
        String externalStorageState;
        File appCacheDir = null;
        try {
            externalStorageState = Environment.getExternalStorageState();
        }
        catch (NullPointerException e) {
            externalStorageState = "";
        }
        catch (IncompatibleClassChangeError e) {
            externalStorageState = "";
        }
        if (preferExternal && "mounted".equals(externalStorageState) && (appCacheDir = context.getExternalFilesDir(null)) != null && appCacheDir.exists() && !(appCacheDir = new File(appCacheDir.getPath() + File.separator + NORMAL_CACHE)).exists() && !appCacheDir.mkdir()) {
            Log.w((String)TAG, (String)"can't create cache file");
        }
        if (!(appCacheDir != null && (appCacheDir.exists() || appCacheDir.mkdirs()) || (appCacheDir = Commutil.getExternalCacheDir((Context)context.getApplicationContext())) != null && appCacheDir.exists())) {
            appCacheDir = context.getFilesDir();
        }
        if (appCacheDir == null || !appCacheDir.exists()) {
            appCacheDir = context.getCacheDir();
        }
        if (appCacheDir == null) {
            String cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + NORMAL_CACHE;
            Log.w((String)TAG, (String)("Can't define system cache directory! '%s' will be used." + cacheDirPath));
            appCacheDir = new File(cacheDirPath);
        }
        return appCacheDir;
    }

    public static File getOfflineCacheDirectory(Context context, boolean preferExternal) {
        String cacheDirPath;
        boolean result;
        String path;
        String externalStorageState;
        File appCacheDir = null;
        try {
            externalStorageState = Environment.getExternalStorageState();
        }
        catch (NullPointerException e) {
            externalStorageState = "";
        }
        catch (IncompatibleClassChangeError e) {
            externalStorageState = "";
        }
        if (preferExternal && "mounted".equals(externalStorageState) && (appCacheDir = context.getExternalFilesDir(null)) != null && !(appCacheDir = new File(path = appCacheDir.getPath() + File.separator + OFFLINE_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getOfflineCacheDirectory,storage cache is not ready");
        }
        if (appCacheDir == null && !(appCacheDir = new File(cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + OFFLINE_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getOfflineCacheDirectory,app cache path is not ready");
        }
        return appCacheDir;
    }

    public static File getIndividualCacheDirectory(Context context) {
        return StorageUtils.getIndividualCacheDirectory(context, INDIVIDUAL_DIR_NAME);
    }

    public static File getIndividualCacheDirectory(Context context, String cacheDir) {
        File appCacheDir = StorageUtils.getCacheDirectory(context);
        File individualCacheDir = new File(appCacheDir, cacheDir);
        if (!individualCacheDir.exists() && !individualCacheDir.mkdir()) {
            individualCacheDir = appCacheDir;
        }
        return individualCacheDir;
    }

    public static File getOwnCacheDirectory(Context context, String cacheDir) {
        File appCacheDir = null;
        if ("mounted".equals(Environment.getExternalStorageState()) && StorageUtils.hasExternalStoragePermission(context)) {
            appCacheDir = new File(Environment.getExternalStorageDirectory(), cacheDir);
        }
        if (appCacheDir == null || !appCacheDir.exists() && !appCacheDir.mkdirs()) {
            appCacheDir = context.getCacheDir();
        }
        return appCacheDir;
    }

    public static File getOwnCacheDirectory(Context context, String cacheDir, boolean preferExternal) {
        File appCacheDir = null;
        if (preferExternal && "mounted".equals(Environment.getExternalStorageState()) && StorageUtils.hasExternalStoragePermission(context)) {
            appCacheDir = new File(Environment.getExternalStorageDirectory(), cacheDir);
        }
        if (!(appCacheDir != null && (appCacheDir.exists() || appCacheDir.mkdirs()) || (appCacheDir = Commutil.getExternalCacheDir((Context)context.getApplicationContext())) != null && appCacheDir.exists())) {
            appCacheDir = context.getCacheDir();
        }
        return appCacheDir;
    }

    public static File getOwnCacheDirectory(Context context) {
        File cacheDir = context.getFilesDir();
        if (cacheDir == null || !cacheDir.exists()) {
            cacheDir = context.getCacheDir();
        }
        return cacheDir;
    }

    private static File getExternalCacheDir(Context context) {
        File dataDir = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File appCacheDir = new File(new File(new File(dataDir, context.getPackageName()), "files"), "images");
        if (!appCacheDir.exists()) {
            if (!appCacheDir.mkdirs()) {
                Log.w((String)"error", (String)"Unable to create external cache directory");
                return null;
            }
            try {
                new File(appCacheDir, ".nomedia").createNewFile();
            }
            catch (IOException e) {
                Log.i((String)"error", (String)"Can't create \".nomedia\" file in application external cache directory");
            }
        }
        return appCacheDir;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        int perm = context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION);
        return perm == 0;
    }
}

