/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.disklrucache.impl;

import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.net.disklrucache.DiskLruCache;
import com.cloud.hisavana.net.disklrucache.ImageCacheURL;
import com.cloud.hisavana.net.disklrucache.impl.IDiskCache;
import com.cloud.hisavana.net.disklrucache.utils.DiskLruCacheUtil;
import com.cloud.hisavana.net.disklrucache.utils.SafeKeyUtils;
import com.cloud.hisavana.net.utils.StorageUtils;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class DiskCacheImpl
implements IDiskCache {
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private DiskLruCache diskLruCache;
    private File directory;
    private final long maxSize;
    private final boolean isOfflineMode;

    protected DiskCacheImpl(File directory, long maxSize, boolean isOfflineMode) {
        this.directory = directory;
        this.maxSize = maxSize;
        this.isOfflineMode = isOfflineMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DiskLruCache getDiskLruCache() throws IOException {
        DiskLruCache localDiskLruCache = this.diskLruCache;
        if (localDiskLruCache != null) return localDiskLruCache;
        Class<DiskCacheImpl> clazz = DiskCacheImpl.class;
        synchronized (DiskCacheImpl.class) {
            File cacheFile;
            localDiskLruCache = this.diskLruCache;
            if (localDiskLruCache != null) return localDiskLruCache;
            File file = cacheFile = this.isOfflineMode ? StorageUtils.getOfflineCacheDirectory(CoreUtil.getContext(), true) : StorageUtils.getCacheDirectory(CoreUtil.getContext());
            if (Log.isLoggable((String)"ADSDK", (int)3)) {
                CommonLogUtil.netLog((String)(" ----- getDiskLruCache: directory = " + this.directory + " , cacheFile = " + cacheFile));
            }
            this.directory = this.directory == null ? cacheFile : this.directory;
            this.diskLruCache = DiskLruCache.open(this.directory, 1, 1, this.maxSize);
            return this.diskLruCache;
        }
    }

    @Override
    public File get(ImageCacheURL key) {
        return this.getImageFile(key);
    }

    protected File getImageFile(ImageCacheURL imageURL) {
        File directory;
        if (TextUtils.isEmpty((CharSequence)imageURL.getOriginUrl())) {
            return null;
        }
        File file = directory = this.isOfflineMode ? StorageUtils.getOfflineCacheDirectory(CoreUtil.getContext(), true) : StorageUtils.getCacheDirectory(CoreUtil.getContext());
        if (directory == null) {
            return null;
        }
        String fileName = SafeKeyUtils.getSafeKey(imageURL) + ".0";
        return new File(directory + File.separator + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(ImageCacheURL key, byte[] buf) {
        String filePath = "";
        OutputStream outputStream = null;
        String safeKey = SafeKeyUtils.getSafeKey(key);
        try {
            DiskLruCache.Snapshot currentValue = this.getDiskLruCache().get(safeKey);
            if (currentValue != null) {
                String string = null;
                return string;
            }
            DiskLruCache.Editor editor = this.diskLruCache.edit(safeKey);
            if (editor == null) {
                throw new IllegalStateException("Had two simultaneous puts for: " + safeKey);
            }
            try {
                outputStream = editor.newOutputStream(0);
                outputStream.write(buf);
                outputStream.flush();
                editor.commit();
                this.diskLruCache.flush();
                filePath = DiskLruCacheUtil.getCacheFilePath(key.getOriginUrl(), this.isOfflineMode);
                if (Log.isLoggable((String)"ADSDK", (int)3)) {
                    CommonLogUtil.netLog((String)("url :" + key.getOriginUrl() + "cacheToDisk: " + filePath));
                }
            }
            finally {
                editor.abortUnlessCommitted();
            }
            DiskLruCacheUtil.closeQuietly(outputStream);
        }
        catch (IOException e) {
            CommonLogUtil.netLog((String)("put: fail" + filePath));
        }
        finally {
            DiskLruCacheUtil.closeQuietly(outputStream);
        }
        return filePath;
    }

    @Override
    public void delete(ImageCacheURL key) {
        String safeKey = SafeKeyUtils.getSafeKey(key);
        try {
            this.getDiskLruCache().remove(safeKey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clear() {
        try {
            this.getDiskLruCache().delete();
            this.resetDiskCache();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized void resetDiskCache() {
        this.diskLruCache = null;
    }
}

