/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.disklrucache.utils;

import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.net.HttpRequest;
import com.cloud.hisavana.net.disklrucache.ImageCacheURL;
import com.cloud.hisavana.net.disklrucache.impl.DiskCacheProvider;
import com.cloud.hisavana.net.disklrucache.impl.IDiskCache;
import com.cloud.hisavana.net.disklrucache.utils.SafeKeyUtils;
import com.cloud.hisavana.net.utils.StorageUtils;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class DiskLruCacheUtil {
    public static final Charset US_ASCII = StandardCharsets.US_ASCII;
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static IDiskCache diskCache;
    private static final char[] HEX_CHAR_ARRAY;
    private static final char[] SHA_256_CHARS;

    private DiskLruCacheUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha256BytesToHex(byte[] bytes) {
        char[] cArray = SHA_256_CHARS;
        synchronized (SHA_256_CHARS) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DiskLruCacheUtil.bytesToHex(bytes, SHA_256_CHARS);
        }
    }

    private static String bytesToHex(byte[] bytes, char[] hexChars) {
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHAR_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHAR_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ignored) {
                CommonLogUtil.netLog((String)("closeQuietly --> " + Log.getStackTraceString((Throwable)ignored)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        try {
            int count;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("not a readable directory: " + dir);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                DiskLruCacheUtil.deleteContents(file);
            }
            if (file.delete()) continue;
            throw new IOException("failed to delete file: " + file);
        }
    }

    public static IDiskCache getDiskCache(boolean isOfflineMode) {
        if (CoreUtil.getContext() != null) {
            long maxSize = isOfflineMode ? (HttpRequest.INSTANCE.getOfflineCacheSize() <= 0 ? 0x3200000L : (long)(HttpRequest.INSTANCE.getOfflineCacheSize() * 1024) * 1024L) : (HttpRequest.INSTANCE.getCacheSize() <= 0 ? 0x6400000L : (long)(HttpRequest.INSTANCE.getCacheSize() * 1024) * 1024L);
            diskCache = new DiskCacheProvider().getDiskCache(maxSize, isOfflineMode);
        }
        return diskCache;
    }

    public static String getCacheFilePath(String url, boolean isOfflineAd) {
        File directory;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        File file = directory = isOfflineAd ? StorageUtils.getOfflineCacheDirectory(CoreUtil.getContext(), true) : StorageUtils.getCacheDirectory(CoreUtil.getContext());
        if (directory == null) {
            return "";
        }
        ImageCacheURL imageURL = new ImageCacheURL(url);
        String fileName = SafeKeyUtils.getSafeKey(imageURL) + ".0";
        return directory + File.separator + fileName;
    }

    static {
        HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
        SHA_256_CHARS = new char[64];
    }
}

