/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.interceptor;

import android.util.Log;
import androidx.annotation.NonNull;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RequestInterceptor
implements Interceptor {
    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request().newBuilder().build();
        if (Log.isLoggable((String)"ADSDK", (int)3)) {
            CommonLogUtil.netLog((String)("requestUrl=" + request.url()));
            CommonLogUtil.netLog((String)("[request-headers]:" + request.headers()));
        }
        long startNs = System.nanoTime();
        Response response = chain.proceed(request);
        long costMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        if (Log.isLoggable((String)"ADSDK", (int)3)) {
            CommonLogUtil.netLog((String)("[costs]:" + costMs + "ms"));
            CommonLogUtil.netLog((String)("[response-code]:" + response.code()));
        }
        return response;
    }
}

