package com.cloud.hisavana.net;


import com.cloud.hisavana.net.constants.HttpCode;
import com.cloud.hisavana.net.impl.IHttpCallback;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;

import java.util.HashMap;
import java.util.Map;

import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

/**
 * 公共入参
 *
 * @author chenshijun
 */

public class CommonRequest {

    private CommonRequest() {
        throw new IllegalStateException("Utility class");
    }

    /**
     * 创建Get请求的Request
     */
    public static Request createGetRequest(String url, RequestParams params, IHttpCallback callback) {
        try {
            StringBuilder urlBuilder = new StringBuilder(url).append("?");

            if (params != null && !params.getHttpParams().isEmpty()) {
                for (Map.Entry<String, String> entry : params.getHttpParams().entrySet()) {
                    urlBuilder.append(entry.getKey())
                            .append("=")
                            .append(entry.getValue())
                            .append("&");
                }
            }

            if (params != null) {
                return new Request.Builder()
                        .url(urlBuilder.substring(0, urlBuilder.length() - 1))
                        .headers(getHeaders(params.getHttpHeaders()))
                        .get().build();
            } else {
                return new Request.Builder()
                        .url(urlBuilder.substring(0, urlBuilder.length() - 1))
                        .get().build();
            }
        } catch (Exception e) {
            if (callback != null) {
                callback.sendFailureMessage(HttpCode.HTTP_CREATE_REQUEST_FAIL, null, e);
            }
        }
        return null;
    }

    /**
     * 创建Post请求的Request
     *
     * @return 返回一个创建好的Request对象
     */
    public static Request createPostRequest(String url, RequestParams params, IHttpCallback callback) {

        try {
            return new Request.Builder()
                    .url(url)
                    .headers(getHeaders(params.getHttpHeaders()))
                    .post(getJSONBody(params.getPostBody()))
                    .build();
        } catch (Exception e) {
                if (callback != null) {
                    callback.sendFailureMessage(HttpCode.HTTP_CREATE_REQUEST_FAIL, null, e);
                }
            }
        return null;
    }

    /**
     * 返回RequestBody对象
     */
    private static RequestBody getRawBody(String content, MediaType type) {
        return RequestBody.create(type, content);
    }

    /**
     * Content-Type: application/json
     */
    private static RequestBody getJSONBody(Object json) {
        return getRawBody(GsonUtil.toJson(json), MediaType.parse(ContentType.JSON.toString()));
    }

    /**
     * 得到网络请求的Headers
     */
    private static Headers getHeaders(Map<String, String> headerMaps) {
        Map<String, String> headers = headerMaps;
        if (headers == null) {
            headers = new HashMap();
        }

        if (!headers.isEmpty()) {
            return Headers.of(headers);
        }
        return new Headers.Builder().build();
    }
}
