package com.cloud.hisavana.net.disklrucache;

import android.net.Uri;
import android.text.TextUtils;

import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.MD5;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * DiskLruCache存储的信息
 * @author chenshijun
 */
public class ImageCacheURL {
    private static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    private volatile byte[] cacheKeyBytes;
    private final String safeStringUrl;
    private final String originUrl;
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public ImageCacheURL(String url) {
        if (!TextUtils.isEmpty(url)) {
            originUrl = url;
            safeStringUrl = Uri.encode(url, ALLOWED_URI_CHARS);
        } else {
            originUrl = "";
            safeStringUrl = "";
            CommonLogUtil.netLog("url must be can not null or empty");
        }
    }

    public String getKey() {
        return toMD5();
    }

    public String getOriginUrl() {
        return originUrl;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ImageCacheURL) {
            ImageCacheURL other = (ImageCacheURL) obj;
            return getKey().equals(other.getKey());
        }
        return false;
    }

    public String toMD5() {
        return MD5.MD5Encode(safeStringUrl);
    }

    public byte[] getCacheKeyBytes() {
        if (cacheKeyBytes == null) {
            cacheKeyBytes = safeStringUrl.getBytes(CHARSET);
        }
        return cacheKeyBytes;
    }

    @Override
    public int hashCode() {
        int hashCode = safeStringUrl.hashCode();
        hashCode = 31 * hashCode;
        return hashCode;
    }
}
