package com.cloud.hisavana.net.impl;

import android.os.Looper;

import java.io.UnsupportedEncodingException;

import okhttp3.Headers;

/**
 * 文本的回调
 * @author chenshijun
 */
public abstract class StringCallback extends HttpCallbackImpl {

    protected StringCallback(Looper looper) {
        super(looper);
    }

    protected StringCallback() {
        super();
    }

    /**
     * 是否将回调放到请求线程
     * @param isSwitchToRequestThread
     */
    public StringCallback(boolean isSwitchToRequestThread) {
        super(isSwitchToRequestThread);
    }

    public abstract void onFailure(int statusCode, String responseString, Throwable throwable);

    public abstract void onSuccess(int statusCode, String responseString);

    @Override
    public void onResponseHeader(Headers responseHeaders) {
    }

    public static String getResponseString(byte[] stringBytes, String charset) throws UnsupportedEncodingException {
        String toReturn = (stringBytes == null) ? null : new String(stringBytes, charset);
        if (toReturn != null && toReturn.startsWith(UTF8_BOM)) {
            return toReturn.substring(1);
        }
        return toReturn;
    }

    @Override
    public void onSuccess(final int statusCode, final byte[] responseBody) {
        try {
            final String responseString = getResponseString(responseBody, DEFAULT_CHARSET);
            postRunnable(new Runnable() {
                @Override
                public void run() {
                    onSuccess(statusCode, responseString);
                }
            });
        } catch (final UnsupportedEncodingException e) {
            postRunnable(new Runnable() {
                @Override
                public void run() {
                    onFailure(statusCode, (String) null, e.getCause());
                }
            });
        }
    }

    @Override
    public void onFailure(final int statusCode, final byte[] responseBody, final Throwable error) {
        try {
            final String responseString = getResponseString(responseBody, DEFAULT_CHARSET);
            postRunnable(new Runnable() {
                @Override
                public void run() {
                    onFailure(statusCode, responseString, error);
                }
            });
        } catch (final UnsupportedEncodingException e) {
            postRunnable(new Runnable() {
                @Override
                public void run() {
                    onFailure(statusCode, (String) null, e.getCause());
                }
            });
        }
    }
}
