/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net;

import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.net.RequestParams;
import com.cloud.hisavana.net.disklrucache.ImageCacheURL;
import com.cloud.hisavana.net.disklrucache.impl.IDiskCache;
import com.cloud.hisavana.net.disklrucache.utils.DiskLruCacheUtil;
import com.cloud.hisavana.net.impl.IHttpCallback;
import com.cloud.hisavana.net.interceptor.RequestInterceptor;
import com.cloud.hisavana.net.ssl.HttpsTrustManager;
import com.cloud.hisavana.net.utils.ByteBufferUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsin.networkmonitor.MonitorFactory;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class CommonOkHttpClient {
    public static final String TAG = "ADSDK";
    private static final int TIME_OUT = 30;
    public static boolean isTestRequest = false;
    private static Dispatcher adDispatcher;
    private static EventListener.Factory mediaFactory;
    private static Exception ERROR_BODY_EMPTY;

    private CommonOkHttpClient() {
        throw new IllegalStateException("Utility class");
    }

    public static OkHttpClient getOkHttpClient() {
        return GeneralOkHttpClient.commonOkHttpClient;
    }

    public static void setOkHttpDispatcher(Dispatcher dispatcher) {
        CommonOkHttpClient.setOkHttpClient(dispatcher, null);
    }

    public static void setOkHttpClient(Dispatcher dispatcher, EventListener.Factory factory) {
        adDispatcher = dispatcher;
        mediaFactory = factory;
    }

    public static Call get(Request request, final IHttpCallback callback) {
        try {
            Call call = CommonOkHttpClient.getOkHttpClient().newCall(request);
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    try {
                        if (callback == null) {
                            return;
                        }
                        if (e instanceof SocketTimeoutException) {
                            callback.sendFailureMessage(481, null, e);
                        } else if (e instanceof UnknownHostException) {
                            callback.sendFailureMessage(484, null, e);
                        } else if (e instanceof NoRouteToHostException) {
                            callback.sendFailureMessage(485, null, e);
                        } else if (e instanceof ProtocolException) {
                            callback.sendFailureMessage(486, null, e);
                        } else if (e instanceof ConnectException) {
                            callback.sendFailureMessage(483, null, e);
                        } else {
                            callback.sendFailureMessage(480, null, e);
                        }
                    }
                    catch (Exception exception) {
                        if (callback != null) {
                            callback.sendFailureMessage(480, null, e);
                        }
                        CommonOkHttpClient.printException(exception);
                    }
                }

                public void onResponse(Call call, Response response) throws IOException {
                    block7: {
                        try {
                            if (callback == null) {
                                return;
                            }
                            if (response != null) {
                                byte[] body = response.body().bytes();
                                if (body != null && body.length > 0) {
                                    callback.sendResponseMessage(response.code(), body, response.headers());
                                } else {
                                    callback.sendFailureMessage(1027, null, ERROR_BODY_EMPTY);
                                }
                            } else {
                                callback.sendFailureMessage(1027, null, ERROR_BODY_EMPTY);
                            }
                        }
                        catch (Exception e) {
                            if (response == null) break block7;
                            callback.sendFailureMessage(response.code(), null, e);
                        }
                    }
                }
            });
            return call;
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.sendFailureMessage(480, null, exception);
            }
            CommonOkHttpClient.printException(exception);
            return null;
        }
    }

    public static Call post(Request request, final IHttpCallback callback) {
        if (callback != null) {
            callback.sendStartMessage();
        }
        try {
            Call call = CommonOkHttpClient.getOkHttpClient().newCall(request);
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    try {
                        if (callback == null) {
                            return;
                        }
                        if (e instanceof SocketTimeoutException) {
                            callback.sendFailureMessage(481, null, e);
                        } else if (e instanceof UnknownHostException) {
                            callback.sendFailureMessage(484, null, e);
                        } else if (e instanceof NoRouteToHostException) {
                            callback.sendFailureMessage(485, null, e);
                        } else if (e instanceof ProtocolException) {
                            callback.sendFailureMessage(486, null, e);
                        } else if (e instanceof ConnectException) {
                            callback.sendFailureMessage(483, null, e);
                        } else {
                            callback.sendFailureMessage(480, null, e);
                        }
                    }
                    catch (Exception exception) {
                        if (callback != null) {
                            callback.sendFailureMessage(480, null, e);
                        }
                        CommonOkHttpClient.printException(exception);
                    }
                }

                public void onResponse(Call call, Response response) throws IOException {
                    block7: {
                        try {
                            if (callback == null) {
                                return;
                            }
                            if (response != null) {
                                byte[] body = response.body().bytes();
                                if (body != null && body.length > 0) {
                                    callback.sendResponseMessage(response.code(), body, response.headers());
                                } else {
                                    callback.sendFailureMessage(1027, null, ERROR_BODY_EMPTY);
                                }
                            } else {
                                callback.sendFailureMessage(1027, null, ERROR_BODY_EMPTY);
                            }
                        }
                        catch (Exception e) {
                            if (response == null) break block7;
                            callback.sendFailureMessage(response.code(), null, e);
                        }
                    }
                }
            });
            return call;
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.sendFailureMessage(480, null, exception);
            }
            CommonOkHttpClient.printException(exception);
            return null;
        }
    }

    public static Call downLoadImg(RequestParams params, Request request, IHttpCallback callback) {
        block8: {
            if (Log.isLoggable((String)TAG, (int)3)) {
                CommonLogUtil.netLog((String)("downLoadImg okhttp------> run Current Looper:" + (Looper.myLooper() == Looper.getMainLooper() ? "Main Looper" : "thread Looper")));
            }
            boolean isFromCache = false;
            try {
                IDiskCache diskCache;
                if (!params.isUseCache() || (diskCache = DiskLruCacheUtil.getDiskCache(params.isSwitchOffLineCache())) == null) break block8;
                File imageFile = diskCache.get(new ImageCacheURL(request.url().toString()));
                if (imageFile != null && imageFile.exists() && imageFile.length() > 0L) {
                    isFromCache = true;
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        CommonLogUtil.netLog((String)("image url:" + request.url()));
                        CommonLogUtil.netLog((String)("image path:" + imageFile.getPath()));
                    }
                    if (callback != null) {
                        if (params.isFetchFilePath()) {
                            callback.sendResponseMessage(250, ByteBufferUtil.toBytes(ByteBufferUtil.fromFile(imageFile)), imageFile.getPath());
                        } else {
                            callback.sendResponseMessage(250, ByteBufferUtil.toBytes(ByteBufferUtil.fromFile(imageFile)));
                        }
                        return null;
                    }
                    break block8;
                }
                return CommonOkHttpClient.realDownLoadImage(params, request, callback);
            }
            catch (IOException e) {
                CommonLogUtil.netLog((String)("downLoadImg: --> " + Log.getStackTraceString((Throwable)e)));
                if (callback == null || !isFromCache) break block8;
                callback.sendFailureMessage(256, null, e);
            }
        }
        return CommonOkHttpClient.realDownLoadImage(params, request, callback);
    }

    private static Call realDownLoadImage(final RequestParams params, final Request request, final IHttpCallback callback) {
        try {
            Call call = CommonOkHttpClient.getOkHttpClient().newCall(request);
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    try {
                        if (callback == null) {
                            return;
                        }
                        if (e instanceof SocketTimeoutException) {
                            callback.sendFailureMessage(481, null, e);
                        } else if (e instanceof UnknownHostException) {
                            callback.sendFailureMessage(484, null, e);
                        } else if (e instanceof NoRouteToHostException) {
                            callback.sendFailureMessage(485, null, e);
                        } else if (e instanceof ProtocolException) {
                            callback.sendFailureMessage(486, null, e);
                        } else if (e instanceof ConnectException) {
                            callback.sendFailureMessage(483, null, e);
                        } else {
                            callback.sendFailureMessage(480, null, e);
                        }
                    }
                    catch (Exception exception) {
                        if (callback != null) {
                            callback.sendFailureMessage(480, null, e);
                        }
                        CommonOkHttpClient.printException(exception);
                    }
                }

                public void onResponse(Call call, Response response) {
                    block13: {
                        try {
                            if (callback == null) {
                                return;
                            }
                            if (response != null) {
                                byte[] body = response.body().bytes();
                                if (body != null && body.length > 0) {
                                    if (!params.isFetchFilePath()) {
                                        callback.sendResponseMessage(response.code(), body, response.headers());
                                    }
                                    String filePath = CommonOkHttpClient.cacheToDisk(params, request.url().toString(), response.code(), body);
                                    if (Log.isLoggable((String)CommonOkHttpClient.TAG, (int)3)) {
                                        CommonLogUtil.netLog((String)("onResponse: url = " + request.url() + " , code = " + response.code() + " , filePath = " + filePath));
                                    }
                                    if (params.isFetchFilePath()) {
                                        if (CommonOkHttpClient.isFilePathExist(filePath)) {
                                            callback.sendResponseMessage(response.code(), body, filePath);
                                        } else {
                                            callback.sendFailureMessage(1026, null, new Exception("fail to cache file to disk"));
                                        }
                                    }
                                } else {
                                    callback.sendFailureMessage(1027, null, ERROR_BODY_EMPTY);
                                }
                            } else {
                                callback.sendFailureMessage(1027, null, ERROR_BODY_EMPTY);
                            }
                        }
                        catch (Exception e) {
                            if (callback == null || response == null) break block13;
                            callback.sendFailureMessage(response.code(), null, e);
                        }
                    }
                    if (callback != null) {
                        callback.sendFinishMessage();
                    }
                }
            });
            return call;
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.sendFailureMessage(480, null, exception);
            }
            CommonOkHttpClient.printException(exception);
            return null;
        }
    }

    private static String cacheToDisk(RequestParams params, String url, int code, byte[] buf) {
        String filePath = "";
        try {
            IDiskCache diskCache = DiskLruCacheUtil.getDiskCache(params.isSwitchOffLineCache());
            if (params.isUseCache() && diskCache != null && code < 300) {
                filePath = diskCache.put(new ImageCacheURL(url), buf);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    CommonLogUtil.netLog((String)("url :" + url + " , write cache finish.  filePath = " + filePath));
                }
            }
        }
        catch (Exception e) {
            CommonLogUtil.netLog((String)("cacheToDisk is failure, " + Log.getStackTraceString((Throwable)e)));
        }
        return filePath;
    }

    private static boolean isFilePathExist(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.length() > 0L;
    }

    private static void printException(Exception e) {
        if (Log.isLoggable((String)TAG, (int)3) && e != null) {
            CommonLogUtil.netLog((String)("onFailure:  " + Log.getStackTraceString((Throwable)e)));
        }
    }

    static {
        ERROR_BODY_EMPTY = new Exception("http response body is empty");
    }

    private static class GeneralOkHttpClient {
        private static final OkHttpClient commonOkHttpClient = GeneralOkHttpClient.getBuilder().build();

        private GeneralOkHttpClient() {
        }

        private static OkHttpClient.Builder getBuilder() {
            OkHttpClient.Builder builder = isTestRequest ? new OkHttpClient.Builder().sslSocketFactory(HttpsTrustManager.createSSLSocketFactory(), (X509TrustManager)new HttpsTrustManager()).hostnameVerifier((HostnameVerifier)new HttpsTrustManager.TrustAllHostnameVerifier()).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)new RequestInterceptor()).dispatcher(adDispatcher != null ? adDispatcher : new Dispatcher()).eventListenerFactory((EventListener.Factory)new MonitorFactory(mediaFactory, 0, isTestRequest)) : new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)new RequestInterceptor()).dispatcher(adDispatcher != null ? adDispatcher : new Dispatcher()).eventListenerFactory((EventListener.Factory)new MonitorFactory(mediaFactory, 0, isTestRequest));
            CommonLogUtil.netLog((String)("getBuilder: isTestRequest = " + isTestRequest));
            return builder;
        }
    }
}

