package com.cloud.hisavana.net.disklrucache.impl;


/**
 * 提供缓存池
 *
 * @author chenshijun
 */
public class DiskCacheProvider implements IDiskCache.Provider {

    /**
     * 默认缓存池
     */
    private volatile IDiskCache normalDiskCache;
    /**
     * 离线缓存池
     */
    private volatile IDiskCache offlineDiskCache;

    @Override
    public IDiskCache getDiskCache(long cacheMaxSize, boolean isSwitchOffline) {
        if (isSwitchOffline) {
            if (offlineDiskCache == null) {
                synchronized (this) {
                    if (offlineDiskCache == null) {
                        offlineDiskCache = new DiskLruCacheFactory(cacheMaxSize, true).build();
                    }
                }
            }
            return offlineDiskCache;
        } else {
            if (normalDiskCache == null) {
                synchronized (this) {
                    if (normalDiskCache == null) {
                        normalDiskCache = new DiskLruCacheFactory(cacheMaxSize, false).build();
                    }
                }
            }
            return normalDiskCache;
        }
    }
}
