package com.cloud.hisavana.net

import java.util.concurrent.ConcurrentHashMap

/**
 * 请求参数
 *
 * @author chenshijun
 */
class RequestParams {
    /** 请求body  */
    var postBody: Any = ""
        set(body) {
            if (body != null) {
                field = body
            }
        }

    /**  线程安全的HashMap  */
    val httpHeaders = ConcurrentHashMap<String, String>()
    val httpParams = ConcurrentHashMap<String, String>()
    /** 是否需要返回物料路径 */
    var isFetchFilePath = false
    /** 是否使用cache */
    var isUseCache = true
    /** 是否使用离线缓存库 */
    var isSwitchOffLineCache = false

    /**
     * 添加get请求时的params参数
     */
    fun putParams(key: String?, value: String?) {
        if (key != null && value != null) {
            httpParams[key] = value
        }
    }

    fun putHeads(key: String?, value: String?) {
        if (key != null && value != null) {
            httpHeaders[key] = value
        }
    }
}