/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.utils;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.transsion.core.utils.Commutil;
import java.io.File;

public final class StorageUtils {
    private static final String OFFLINE_CACHE = "offline_cache";
    private static final String NORMAL_CACHE = "hisavana_net_cache";
    private static final String VIDEO_CACHE = "hisavana_video_cache";
    private static final String TAG = "StorageUtils";

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        return StorageUtils.getCacheDirectory(context, true);
    }

    public static File getCacheDirectory(Context context, boolean preferExternal) {
        String externalStorageState;
        File appCacheDir = null;
        try {
            externalStorageState = Environment.getExternalStorageState();
        }
        catch (NullPointerException e) {
            externalStorageState = "";
        }
        catch (IncompatibleClassChangeError e) {
            externalStorageState = "";
        }
        if (preferExternal && "mounted".equals(externalStorageState) && (appCacheDir = context.getExternalFilesDir(null)) != null && appCacheDir.exists() && !(appCacheDir = new File(appCacheDir.getPath() + File.separator + NORMAL_CACHE)).exists() && !appCacheDir.mkdir()) {
            Log.w((String)TAG, (String)"can't create cache file");
        }
        if (!(appCacheDir != null && (appCacheDir.exists() || appCacheDir.mkdirs()) || (appCacheDir = Commutil.getExternalCacheDir((Context)context.getApplicationContext())) != null && appCacheDir.exists())) {
            appCacheDir = context.getFilesDir();
        }
        if (appCacheDir == null || !appCacheDir.exists()) {
            appCacheDir = context.getCacheDir();
        }
        if (appCacheDir == null) {
            String cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + NORMAL_CACHE;
            Log.w((String)TAG, (String)("Can't define system cache directory! '%s' will be used." + cacheDirPath));
            appCacheDir = new File(cacheDirPath);
        }
        return appCacheDir;
    }

    public static File getOfflineCacheDirectory(Context context, boolean preferExternal) {
        String cacheDirPath;
        boolean result;
        String path;
        String externalStorageState;
        File appCacheDir = null;
        try {
            externalStorageState = Environment.getExternalStorageState();
        }
        catch (NullPointerException e) {
            externalStorageState = "";
        }
        catch (IncompatibleClassChangeError e) {
            externalStorageState = "";
        }
        if (preferExternal && "mounted".equals(externalStorageState) && (appCacheDir = context.getExternalFilesDir(null)) != null && !(appCacheDir = new File(path = appCacheDir.getPath() + File.separator + OFFLINE_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getOfflineCacheDirectory,storage cache is not ready");
        }
        if (appCacheDir == null && !(appCacheDir = new File(cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + OFFLINE_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getOfflineCacheDirectory,app cache path is not ready");
        }
        return appCacheDir;
    }

    public static File getExoCacheDirectory(Context context, boolean preferExternal) {
        String cacheDirPath;
        boolean result;
        String path;
        String externalStorageState;
        File appCacheDir = null;
        try {
            externalStorageState = Environment.getExternalStorageState();
        }
        catch (NullPointerException e) {
            externalStorageState = "";
        }
        catch (IncompatibleClassChangeError e) {
            externalStorageState = "";
        }
        if (preferExternal && "mounted".equals(externalStorageState) && (appCacheDir = context.getExternalFilesDir(null)) != null && !(appCacheDir = new File(path = appCacheDir.getPath() + File.separator + VIDEO_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getExoCacheDirectory,storage cache is not ready");
        }
        if (appCacheDir == null && !(appCacheDir = new File(cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + OFFLINE_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getExoCacheDirectory,app cache path is not ready");
        }
        return appCacheDir;
    }
}

