package com.cloud.hisavana.net.disklrucache.impl;

import com.cloud.hisavana.net.disklrucache.ImageCacheURL;

import java.io.File;

/**
 * DiskLruCache操作接口
 *
 * @author chenshijun
 */
public interface IDiskCache {
    interface Factory {
        /** default image cache size */
        long DEFAULT_DISK_CACHE_SIZE = 100 * 1024 * 1024L;
        /** default offline cache size */
        long DEFAULT_OFFLINE_CACHE_SIZE = 50 * 1024 * 1024L;

        /**
         * 创建DiskCache
         */
        IDiskCache build();
    }

    interface Provider {
        /**
         * 提供DiskCache
         */
        IDiskCache getDiskCache(long cacheMaxSize, boolean isOffLineCache);
    }

    /**
     * 根据Key获取本地缓存的文件
     * @param key
     * @return
     */
    File get(ImageCacheURL key);

    /**
     * 通过DiskCache缓存到本地文件
     */
    String put(ImageCacheURL key, byte[] buf);

    /**
     * 根据Key缓存到本地文件
     */
    void delete(ImageCacheURL key);

    /**
     * 清空本地缓存
     */
    void clear();

}
