package com.cloud.hisavana.net.constants

/**
 * 错误码
 * @author chenshijun
 */
class HttpCode private constructor() {
    init {
        throw IllegalStateException("Utility class")
    }

    companion object {
        /** 默认错误码  */
        const val HTTP_DEFAULT_RESPONSE_CODE = 480

        /** 网络超时  */
        const val HTTP_TIMEOUT_CODE = 481

        /** 请求服务器失败  */
        const val HTTP_Request_ERROR_CODE = 483

        /** 未知主机异常，例如域名解析失败等  */
        const val HTTP_UNKNOWN_HOST_ERROR_CODE = 484

        /** 无法到达主机异常，例如网络中断等  */
        const val HTTP_NO_ROUTE_TO_HOST_ERROR_CODE = 485

        /** 协议异常，例如不支持的协议等  */
        const val HTTP_PROTOCOL_ERROR_CODE = 486

        /** 构建request失败  */
        const val HTTP_CREATE_REQUEST_FAIL = 490

        /** 缓存文件到DiskLruCache失败  */
        const val ERROR_CACHE_FILE_TO_DISK = 1026

        /** 网络返回response为空  */
        const val ERROR_RESPONSE_EMPTY = 1027

        /** 网络请求正确和错误回调的code  */
        const val HTTP_CODE_DIVIDER = 300

        /** reture image cache file 。  */
        const val HTTP_IMAGE_CACHE = 250

        /** get data from disk fail  */
        const val FROM_DISK_FAIL = 256

        /** 需要重定向的code  */
        const val REDIRECT_301 = 301
        const val REDIRECT_302 = 302
    }
}