package com.cloud.hisavana.net.disklrucache.impl;


import com.cloud.hisavana.net.HttpRequest;

/**
 * 提供缓存池
 *
 * @author chenshijun
 */
public class DiskCacheProvider implements IDiskCache.Provider {

    /**
     * 默认缓存池
     */
    private volatile IDiskCache normalDiskCache;
    /**
     * 离线缓存池
     */
    private volatile IDiskCache offlineDiskCache;

    /**
     * 视频缓存池
     */
    private volatile IDiskCache videoDiskCache;

    @Override
    public IDiskCache getDiskCache(long cacheMaxSize, int cacheMode) {
        switch (cacheMode) {
            case HttpRequest.OFFLINE_MODE:
                return getOfflineDiskCache(cacheMaxSize);
            case HttpRequest.VIDEO_MODE:
                return getVideoDiskCache(cacheMaxSize);
            default:
                return getOnLineDiskCache(cacheMaxSize);
        }
    }

    private IDiskCache getOfflineDiskCache(long cacheMaxSize) {
        if (offlineDiskCache == null) {
            synchronized (this) {
                if (offlineDiskCache == null) {
                    offlineDiskCache = new DiskLruCacheFactory(cacheMaxSize, true).build();
                }
            }
        }
        return offlineDiskCache;
    }

    private IDiskCache getOnLineDiskCache(long cacheMaxSize) {
        if (normalDiskCache == null) {
            synchronized (this) {
                if (normalDiskCache == null) {
                    normalDiskCache = new DiskLruCacheFactory(cacheMaxSize, false).build();
                }
            }
        }
        return normalDiskCache;
    }

    private IDiskCache getVideoDiskCache(long cacheMaxSize) {
        if (videoDiskCache == null) {
            synchronized (this) {
                if (videoDiskCache == null) {
                    videoDiskCache = new DiskLruCacheFactory(cacheMaxSize, false).build();
                }
            }
        }
        return videoDiskCache;
    }
}
