package com.cloud.hisavana.net.disklrucache.impl;

import com.cloud.hisavana.net.disklrucache.ImageCacheURL;

import java.io.File;

/**
 * DiskLruCache操作接口
 *
 * @author chenshijun
 */
public interface IDiskCache {
    interface Factory {
        /** default image cache size */
        //根据广告需求，在广告2900版本之后，不再使用离线缓存，故将在线缓存扩大到300M
        long DEFAULT_DISK_CACHE_SIZE = 300 * 1024 * 1024L;
        /** default offline cache size */
        long DEFAULT_OFFLINE_CACHE_SIZE = 100 * 1024 * 1024L;
        /** default video cache size */
        long VIDEO_CACHE_SIZE = 100 * 1024 * 1024L;

        /**
         * 创建DiskCache
         */
        IDiskCache build();
    }

    interface Provider {
        /**
         * 提供DiskCache
         */
        IDiskCache getDiskCache(long cacheMaxSize, int cacheMode);
    }

    /**
     * 根据Key获取本地缓存的文件
     * @param key
     * @return
     */
    File get(ImageCacheURL key);

    /**
     * 通过DiskCache缓存到本地文件
     */
    String put(ImageCacheURL key, byte[] buf);

    /**
     * 根据Key缓存到本地文件
     */
    void delete(ImageCacheURL key);

    /**
     * 清空本地缓存
     */
    void clear();

}
