/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.impl;

import android.os.Looper;
import com.cloud.hisavana.net.impl.HttpCallbackImpl;
import java.io.UnsupportedEncodingException;
import okhttp3.Headers;

public abstract class StringCallback
extends HttpCallbackImpl {
    protected StringCallback(Looper looper) {
        super(looper);
    }

    protected StringCallback() {
    }

    public StringCallback(boolean isSwitchToRequestThread) {
        super(isSwitchToRequestThread);
    }

    public abstract void onFailure(int var1, String var2, Throwable var3);

    public abstract void onSuccess(int var1, String var2);

    @Override
    public void onResponseHeader(Headers responseHeaders) {
    }

    public static String getResponseString(byte[] stringBytes, String charset) throws UnsupportedEncodingException {
        String toReturn = stringBytes == null ? null : new String(stringBytes, charset);
        try {
            if (toReturn != null && toReturn.startsWith("\ufeff")) {
                return toReturn.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return toReturn;
    }

    @Override
    public void onSuccess(final int statusCode, byte[] responseBody) {
        try {
            final String responseString = StringCallback.getResponseString(responseBody, "UTF-8");
            this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    StringCallback.this.onSuccess(statusCode, responseString);
                }
            });
        }
        catch (Exception e) {
            this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    StringCallback.this.onFailure(statusCode, (String)null, e.getCause());
                }
            });
        }
    }

    @Override
    public void onFailure(final int statusCode, byte[] responseBody, final Throwable error) {
        try {
            final String responseString = StringCallback.getResponseString(responseBody, "UTF-8");
            this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    StringCallback.this.onFailure(statusCode, responseString, error);
                }
            });
        }
        catch (Exception e) {
            this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    StringCallback.this.onFailure(statusCode, (String)null, e.getCause());
                }
            });
        }
    }
}

