/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.disklrucache.utils;

import android.util.Log;
import android.util.LruCache;
import com.cloud.hisavana.net.disklrucache.ImageCacheURL;
import com.cloud.hisavana.net.disklrucache.utils.DiskLruCacheUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import java.security.MessageDigest;

public class SafeKeyUtils {
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final LruCache<ImageCacheURL, String> loadIdToSafeHash = new LruCache(1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSafeKey(ImageCacheURL imageCacheURL) {
        String safeKey;
        LruCache<ImageCacheURL, String> lruCache = loadIdToSafeHash;
        synchronized (lruCache) {
            safeKey = (String)loadIdToSafeHash.get((Object)imageCacheURL);
        }
        if (safeKey == null) {
            safeKey = SafeKeyUtils.calculateHexStringDigest(imageCacheURL);
        }
        lruCache = loadIdToSafeHash;
        synchronized (lruCache) {
            loadIdToSafeHash.put((Object)imageCacheURL, (Object)safeKey);
        }
        return safeKey;
    }

    private static String calculateHexStringDigest(ImageCacheURL imageCacheURL) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
            messageDigest.update(imageCacheURL.getCacheKeyBytes());
            byte[] hashedData = messageDigest.digest();
            return DiskLruCacheUtil.sha256BytesToHex(hashedData);
        }
        catch (Exception e) {
            CommonLogUtil.netLog((String)("calculateHexStringDigest: " + Log.getStackTraceString((Throwable)e)));
            return "";
        }
    }
}

