/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.disklrucache.utils;

import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.net.HttpRequest;
import com.cloud.hisavana.net.disklrucache.ImageCacheURL;
import com.cloud.hisavana.net.disklrucache.impl.DiskCacheProvider;
import com.cloud.hisavana.net.disklrucache.impl.IDiskCache;
import com.cloud.hisavana.net.disklrucache.utils.SafeKeyUtils;
import com.cloud.hisavana.net.utils.StorageUtils;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class DiskLruCacheUtil {
    public static final Charset US_ASCII = StandardCharsets.US_ASCII;
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static IDiskCache onlineDiskCache;
    private static IDiskCache offlineDiskCache;
    private static IDiskCache videoDiskCache;
    private static IDiskCache defaultDiskCache;
    private static final char[] HEX_CHAR_ARRAY;
    private static final char[] SHA_256_CHARS;

    private DiskLruCacheUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha256BytesToHex(byte[] bytes) {
        char[] cArray = SHA_256_CHARS;
        synchronized (SHA_256_CHARS) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DiskLruCacheUtil.bytesToHex(bytes, SHA_256_CHARS);
        }
    }

    private static String bytesToHex(byte[] bytes, char[] hexChars) {
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHAR_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHAR_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ignored) {
                CommonLogUtil.netLog((String)("closeQuietly --> " + Log.getStackTraceString((Throwable)ignored)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        try {
            String string;
            StringWriter writer = new StringWriter();
            try {
                int count;
                char[] buffer = new char[1024];
                while ((count = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, count);
                }
                string = writer.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String string2 = "";
                    return string2;
                }
            }
            writer.close();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("not a readable directory: " + dir);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                DiskLruCacheUtil.deleteContents(file);
            }
            if (file.delete()) continue;
            throw new IOException("failed to delete file: " + file);
        }
    }

    public static IDiskCache getDiskCache(int cacheMode) {
        switch (cacheMode) {
            case 4: {
                return DiskLruCacheUtil.getDefaultDIskCache();
            }
        }
        return DiskLruCacheUtil.getOnlineDiskCache();
    }

    private static IDiskCache getOnlineDiskCache() {
        if (onlineDiskCache == null) {
            long maxSize = HttpRequest.INSTANCE.getCacheSize() <= 0 ? 314572800L : (long)(HttpRequest.INSTANCE.getCacheSize() * 1024) * 1024L;
            onlineDiskCache = new DiskCacheProvider().getDiskCache(maxSize, 1);
        }
        return onlineDiskCache;
    }

    private static IDiskCache getOfflineDiskCache() {
        if (offlineDiskCache == null) {
            long maxSize = HttpRequest.INSTANCE.getOfflineCacheSize() <= 0 ? 0x6400000L : (long)(HttpRequest.INSTANCE.getOfflineCacheSize() * 1024) * 1024L;
            offlineDiskCache = new DiskCacheProvider().getDiskCache(maxSize, 2);
        }
        return offlineDiskCache;
    }

    private static IDiskCache getVideoDiskCache() {
        if (videoDiskCache == null) {
            long maxSize = HttpRequest.INSTANCE.getVideoCacheSize() <= 0 ? 0x6400000L : (long)(HttpRequest.INSTANCE.getVideoCacheSize() * 1024) * 1024L;
            videoDiskCache = new DiskCacheProvider().getDiskCache(maxSize, 3);
        }
        return videoDiskCache;
    }

    private static IDiskCache getDefaultDIskCache() {
        if (defaultDiskCache == null) {
            long maxSize = HttpRequest.INSTANCE.getDefaultCacheSize() <= 0 ? 0xC800000L : (long)(HttpRequest.INSTANCE.getDefaultCacheSize() * 1024) * 1024L;
            defaultDiskCache = new DiskCacheProvider().getDiskCache(maxSize, 4);
        }
        return defaultDiskCache;
    }

    public static String getCacheFilePath(String url, int cacheMode) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        File directory = DiskLruCacheUtil.getCacheDirectory(cacheMode);
        if (directory == null) {
            return "";
        }
        ImageCacheURL imageURL = new ImageCacheURL(url);
        String fileName = SafeKeyUtils.getSafeKey(imageURL) + ".0";
        return directory + File.separator + fileName;
    }

    public static File getCacheDirectory(int cacheMode) {
        switch (cacheMode) {
            case 4: {
                return StorageUtils.getDefaultCacheDirectory(CoreUtil.getContext(), true);
            }
        }
        return StorageUtils.getCacheDirectory(CoreUtil.getContext());
    }

    public static String getRealCacheFilePath(String url, boolean isOfflineAd) {
        File directory;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        File file = directory = isOfflineAd ? StorageUtils.getOfflineCacheDirectory(CoreUtil.getContext(), true) : StorageUtils.getCacheDirectory(CoreUtil.getContext());
        if (directory == null) {
            return "";
        }
        ImageCacheURL imageURL = new ImageCacheURL(url);
        String fileName = SafeKeyUtils.getSafeKey(imageURL) + ".0";
        String filePath = directory + File.separator + fileName;
        File file2 = new File(filePath);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        return "";
    }

    static {
        HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
        SHA_256_CHARS = new char[64];
    }
}

