/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.okhttptransport;

import android.util.Log;
import com.cloud.hisavana.protocol.okhttptransport.CronetTransportResponseBody;
import com.cloud.hisavana.protocol.okhttptransport.RequestResponseConverter;
import com.cloud.hisavana.protocol.okhttptransport.RequestResponseConverterBasedBuilder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.chromium.net.CronetEngine;
import org.chromium.net.UrlRequest;

public final class CronetInterceptor
implements Interceptor,
AutoCloseable {
    private static final String TAG = "CronetInterceptor";
    private static final int CANCELLATION_CHECK_INTERVAL_MILLIS = 500;
    private final RequestResponseConverter converter;
    private final Map<Call, UrlRequest> activeCalls = new ConcurrentHashMap<Call, UrlRequest>();
    private final ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(1);

    private CronetInterceptor(RequestResponseConverter converter) {
        this.converter = (RequestResponseConverter)Preconditions.checkNotNull((Object)converter);
        ScheduledFuture<?> unusedFuture = this.scheduledExecutor.scheduleAtFixedRate(() -> {
            Iterator<Map.Entry<Call, UrlRequest>> activeCallsIterator = this.activeCalls.entrySet().iterator();
            while (activeCallsIterator.hasNext()) {
                try {
                    Map.Entry<Call, UrlRequest> activeCall = activeCallsIterator.next();
                    if (!activeCall.getKey().isCanceled()) continue;
                    activeCallsIterator.remove();
                    activeCall.getValue().cancel();
                }
                catch (RuntimeException e) {
                    Log.w((String)TAG, (String)"Unable to propagate cancellation status", (Throwable)e);
                }
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (chain.call().isCanceled()) {
            throw new IOException("Canceled");
        }
        Request request = chain.request();
        RequestResponseConverter.CronetRequestAndOkHttpResponse requestAndOkHttpResponse = this.converter.convert(request, chain.readTimeoutMillis(), chain.writeTimeoutMillis());
        this.activeCalls.put(chain.call(), requestAndOkHttpResponse.getRequest());
        try {
            requestAndOkHttpResponse.getRequest().start();
            return this.toInterceptorResponse(requestAndOkHttpResponse.getResponse(), chain.call());
        }
        catch (IOException | RuntimeException e) {
            this.activeCalls.remove(chain.call());
            throw e;
        }
    }

    public static Builder newBuilder(CronetEngine cronetEngine) {
        return new Builder(cronetEngine);
    }

    @Override
    public void close() {
        this.scheduledExecutor.shutdown();
    }

    private Response toInterceptorResponse(Response response, Call call) {
        Preconditions.checkNotNull((Object)response.body());
        if (response.body() instanceof CronetInterceptorResponseBody) {
            return response;
        }
        return response.newBuilder().body((ResponseBody)new CronetInterceptorResponseBody(response.body(), call)).build();
    }

    private class CronetInterceptorResponseBody
    extends CronetTransportResponseBody {
        private final Call call;

        private CronetInterceptorResponseBody(ResponseBody delegate, Call call) {
            super(delegate);
            this.call = call;
        }

        @Override
        void customCloseHook() {
            CronetInterceptor.this.activeCalls.remove(this.call);
        }
    }

    public static final class Builder
    extends RequestResponseConverterBasedBuilder<Builder, CronetInterceptor> {
        Builder(CronetEngine cronetEngine) {
            super(cronetEngine, Builder.class);
        }

        @Override
        public CronetInterceptor build(RequestResponseConverter converter) {
            return new CronetInterceptor(converter);
        }
    }
}

