/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.okhttptransport;

import com.cloud.hisavana.protocol.okhttptransport.OkHttpBridgeRequestCallback;
import com.cloud.hisavana.protocol.okhttptransport.RedirectStrategy;
import com.cloud.hisavana.protocol.okhttptransport.RequestBodyConverter;
import com.cloud.hisavana.protocol.okhttptransport.ResponseConverter;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.concurrent.Executor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.chromium.net.CronetEngine;
import org.chromium.net.UrlRequest;

final class RequestResponseConverter {
    private static final String CONTENT_LENGTH_HEADER_NAME = "Content-Length";
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String CONTENT_TYPE_HEADER_DEFAULT_VALUE = "application/octet-stream";
    private final CronetEngine cronetEngine;
    private final Executor uploadDataProviderExecutor;
    private final ResponseConverter responseConverter;
    private final RequestBodyConverter requestBodyConverter;
    private final RedirectStrategy redirectStrategy;

    RequestResponseConverter(CronetEngine cronetEngine, Executor uploadDataProviderExecutor, RequestBodyConverter requestBodyConverter, ResponseConverter responseConverter, RedirectStrategy redirectStrategy) {
        this.cronetEngine = cronetEngine;
        this.uploadDataProviderExecutor = uploadDataProviderExecutor;
        this.requestBodyConverter = requestBodyConverter;
        this.responseConverter = responseConverter;
        this.redirectStrategy = redirectStrategy;
    }

    CronetRequestAndOkHttpResponse convert(Request okHttpRequest, int readTimeoutMillis, int writeTimeoutMillis) throws IOException {
        OkHttpBridgeRequestCallback callback = new OkHttpBridgeRequestCallback(readTimeoutMillis, this.redirectStrategy);
        UrlRequest.Builder builder = this.cronetEngine.newUrlRequestBuilder(okHttpRequest.url().toString(), (UrlRequest.Callback)callback, MoreExecutors.directExecutor()).allowDirectExecutor();
        builder.addRequestAnnotation((Object)okHttpRequest.headers());
        builder.setHttpMethod(okHttpRequest.method());
        for (int i = 0; i < okHttpRequest.headers().size(); ++i) {
            builder.addHeader(okHttpRequest.headers().name(i), okHttpRequest.headers().value(i));
        }
        RequestBody body = okHttpRequest.body();
        if (body != null) {
            if (okHttpRequest.header(CONTENT_LENGTH_HEADER_NAME) == null && body.contentLength() != -1L) {
                builder.addHeader(CONTENT_LENGTH_HEADER_NAME, String.valueOf(body.contentLength()));
            }
            if (body.contentLength() != 0L) {
                if (body.contentType() != null) {
                    builder.addHeader(CONTENT_TYPE_HEADER_NAME, body.contentType().toString());
                } else if (okHttpRequest.header(CONTENT_TYPE_HEADER_NAME) == null) {
                    builder.addHeader(CONTENT_TYPE_HEADER_NAME, CONTENT_TYPE_HEADER_DEFAULT_VALUE);
                }
                builder.setUploadDataProvider(this.requestBodyConverter.convertRequestBody(body, writeTimeoutMillis), this.uploadDataProviderExecutor);
            }
        }
        return new CronetRequestAndOkHttpResponse(builder.build(), this.createResponseSupplier(okHttpRequest, callback));
    }

    private ResponseSupplier createResponseSupplier(final Request request, final OkHttpBridgeRequestCallback callback) {
        return new ResponseSupplier(){

            @Override
            public Response getResponse() throws IOException {
                return RequestResponseConverter.this.responseConverter.toResponse(request, callback);
            }

            @Override
            public ListenableFuture<Response> getResponseFuture() {
                return RequestResponseConverter.this.responseConverter.toResponseAsync(request, callback);
            }
        };
    }

    static final class CronetRequestAndOkHttpResponse {
        private final UrlRequest request;
        private final ResponseSupplier responseSupplier;

        CronetRequestAndOkHttpResponse(UrlRequest request, ResponseSupplier responseSupplier) {
            this.request = request;
            this.responseSupplier = responseSupplier;
        }

        public UrlRequest getRequest() {
            return this.request;
        }

        public Response getResponse() throws IOException {
            return this.responseSupplier.getResponse();
        }

        public ListenableFuture<Response> getResponseAsync() {
            return this.responseSupplier.getResponseFuture();
        }
    }

    private static interface ResponseSupplier {
        public Response getResponse() throws IOException;

        public ListenableFuture<Response> getResponseFuture();
    }
}

