/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.okhttptransport;

import androidx.annotation.NonNull;
import com.cloud.hisavana.protocol.okhttptransport.OkHttpBridgeRequestCallback;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.chromium.net.UrlResponseInfo;

final class ResponseConverter {
    private static final String CONTENT_LENGTH_HEADER_NAME = "Content-Length";
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String CONTENT_ENCODING_HEADER_NAME = "Content-Encoding";
    private static final ImmutableSet<String> ENCODINGS_HANDLED_BY_CRONET = ImmutableSet.of((Object)"br", (Object)"deflate", (Object)"gzip", (Object)"x-gzip");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();

    ResponseConverter() {
    }

    Response toResponse(Request request, OkHttpBridgeRequestCallback callback) throws IOException {
        UrlResponseInfo cronetResponseInfo = ResponseConverter.getFutureValue(callback.getUrlResponseInfo());
        Response.Builder responseBuilder = ResponseConverter.createResponse(request, cronetResponseInfo, ResponseConverter.getFutureValue(callback.getBodySource()));
        List<UrlResponseInfo> redirectResponseInfos = callback.getUrlResponseInfoChain();
        List urlChain = cronetResponseInfo.getUrlChain();
        if (!redirectResponseInfos.isEmpty()) {
            Preconditions.checkArgument((urlChain.size() == redirectResponseInfos.size() + 1 ? 1 : 0) != 0, (Object)"The number of redirects should be consistent across URLs and headers!");
            Response priorResponse = null;
            for (int i = 0; i < redirectResponseInfos.size(); ++i) {
                Request redirectedRequest = request.newBuilder().url((String)urlChain.get(i)).build();
                priorResponse = ResponseConverter.createResponse(redirectedRequest, redirectResponseInfos.get(i), null).priorResponse(priorResponse).build();
            }
            responseBuilder.request(request.newBuilder().url((String)Iterables.getLast((Iterable)urlChain)).build()).priorResponse(priorResponse);
        }
        return responseBuilder.build();
    }

    ListenableFuture<Response> toResponseAsync(Request request, OkHttpBridgeRequestCallback callback) {
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{callback.getUrlResponseInfo(), callback.getBodySource()}).call(() -> this.toResponse(request, callback), MoreExecutors.directExecutor());
    }

    private static Response.Builder createResponse(Request request, UrlResponseInfo cronetResponseInfo, @Nullable Source bodySource) throws IOException {
        boolean keepEncodingAffectedHeaders;
        Response.Builder responseBuilder = new Response.Builder();
        String contentType = ResponseConverter.getLastHeaderValue(CONTENT_TYPE_HEADER_NAME, cronetResponseInfo);
        String contentLengthString = null;
        ArrayList contentEncodingItems = new ArrayList();
        for (String contentEncodingHeaderValue : ResponseConverter.getOrDefault(cronetResponseInfo.getAllHeaders(), CONTENT_ENCODING_HEADER_NAME, Collections.emptyList())) {
            Iterables.addAll(contentEncodingItems, (Iterable)COMMA_SPLITTER.split((CharSequence)contentEncodingHeaderValue));
        }
        boolean bl = keepEncodingAffectedHeaders = contentEncodingItems.isEmpty() || !ENCODINGS_HANDLED_BY_CRONET.containsAll(contentEncodingItems);
        if (keepEncodingAffectedHeaders) {
            contentLengthString = ResponseConverter.getLastHeaderValue(CONTENT_LENGTH_HEADER_NAME, cronetResponseInfo);
        }
        ResponseBody responseBody = null;
        if (bodySource != null) {
            responseBody = ResponseConverter.createResponseBody(request, cronetResponseInfo.getHttpStatusCode(), contentType, contentLengthString, bodySource);
        }
        responseBuilder.request(request).code(cronetResponseInfo.getHttpStatusCode()).message(cronetResponseInfo.getHttpStatusText()).protocol(ResponseConverter.convertProtocol(cronetResponseInfo.getNegotiatedProtocol())).body(responseBody);
        for (Map.Entry header : cronetResponseInfo.getAllHeadersAsList()) {
            boolean copyHeader = true;
            if (!keepEncodingAffectedHeaders && (Ascii.equalsIgnoreCase((CharSequence)((CharSequence)header.getKey()), (CharSequence)CONTENT_LENGTH_HEADER_NAME) || Ascii.equalsIgnoreCase((CharSequence)((CharSequence)header.getKey()), (CharSequence)CONTENT_ENCODING_HEADER_NAME))) {
                copyHeader = false;
            }
            if (!copyHeader) continue;
            responseBuilder.addHeader((String)header.getKey(), (String)header.getValue());
        }
        return responseBuilder;
    }

    private static ResponseBody createResponseBody(Request request, int httpStatusCode, @Nullable String contentType, @Nullable String contentLengthString, Source bodySource) throws IOException {
        long contentLength;
        if (request.method().equals("HEAD")) {
            contentLength = 0L;
        } else {
            try {
                contentLength = contentLengthString != null ? Long.parseLong(contentLengthString) : -1L;
            }
            catch (NumberFormatException e) {
                contentLength = -1L;
            }
        }
        if ((httpStatusCode == 204 || httpStatusCode == 205) && contentLength > 0L) {
            throw new ProtocolException("HTTP " + httpStatusCode + " had non-zero Content-Length: " + contentLengthString);
        }
        return ResponseBody.create((MediaType)(contentType != null ? MediaType.parse((String)contentType) : null), (long)contentLength, (BufferedSource)Okio.buffer((Source)bodySource));
    }

    private static Protocol convertProtocol(String negotiatedProtocol) {
        if (negotiatedProtocol.contains("quic")) {
            return Protocol.QUIC;
        }
        if (negotiatedProtocol.contains("h3")) {
            return Protocol.QUIC;
        }
        if (negotiatedProtocol.contains("spdy")) {
            return Protocol.HTTP_2;
        }
        if (negotiatedProtocol.contains("h2")) {
            return Protocol.HTTP_2;
        }
        if (negotiatedProtocol.contains("http/1.1")) {
            return Protocol.HTTP_1_1;
        }
        return Protocol.HTTP_1_0;
    }

    @Nullable
    private static String getLastHeaderValue(String name, UrlResponseInfo responseInfo) {
        List headers = (List)responseInfo.getAllHeaders().get(name);
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        return (String)Iterables.getLast((Iterable)headers);
    }

    private static <T> T getFutureValue(Future<T> future) throws IOException {
        try {
            return (T)Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private static <K, V> V getOrDefault(Map<K, V> map, K key, @NonNull V defaultValue) {
        V value = map.get(key);
        if (value == null) {
            return (V)Preconditions.checkNotNull(defaultValue);
        }
        return value;
    }
}

