/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.disklrucache.impl;

import com.cloud.hisavana.net.disklrucache.impl.DiskLruCacheFactory;
import com.cloud.hisavana.net.disklrucache.impl.IDiskCache;

public class DiskCacheProvider
implements IDiskCache.Provider {
    private volatile IDiskCache normalDiskCache;
    private volatile IDiskCache offlineDiskCache;
    private volatile IDiskCache videoDiskCache;
    private volatile IDiskCache defaultDiskCache;

    @Override
    public IDiskCache getDiskCache(long cacheMaxSize, int cacheMode) {
        switch (cacheMode) {
            case 4: {
                return this.getDefaultDiskCache(cacheMaxSize);
            }
        }
        return this.getOnLineDiskCache(cacheMaxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDiskCache getOfflineDiskCache(long cacheMaxSize) {
        if (this.offlineDiskCache == null) {
            DiskCacheProvider diskCacheProvider = this;
            synchronized (diskCacheProvider) {
                if (this.offlineDiskCache == null) {
                    this.offlineDiskCache = new DiskLruCacheFactory(cacheMaxSize, 2).build();
                }
            }
        }
        return this.offlineDiskCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDiskCache getOnLineDiskCache(long cacheMaxSize) {
        if (this.normalDiskCache == null) {
            DiskCacheProvider diskCacheProvider = this;
            synchronized (diskCacheProvider) {
                if (this.normalDiskCache == null) {
                    this.normalDiskCache = new DiskLruCacheFactory(cacheMaxSize, 1).build();
                }
            }
        }
        return this.normalDiskCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDiskCache getVideoDiskCache(long cacheMaxSize) {
        if (this.videoDiskCache == null) {
            DiskCacheProvider diskCacheProvider = this;
            synchronized (diskCacheProvider) {
                if (this.videoDiskCache == null) {
                    this.videoDiskCache = new DiskLruCacheFactory(cacheMaxSize, 3).build();
                }
            }
        }
        return this.videoDiskCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDiskCache getDefaultDiskCache(long cacheMaxSize) {
        if (this.defaultDiskCache == null) {
            DiskCacheProvider diskCacheProvider = this;
            synchronized (diskCacheProvider) {
                if (this.defaultDiskCache == null) {
                    this.defaultDiskCache = new DiskLruCacheFactory(cacheMaxSize, 4).build();
                }
            }
        }
        return this.defaultDiskCache;
    }
}

