/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.okhttptransport;

import com.cloud.hisavana.protocol.okhttptransport.CronetTimeoutException;
import com.cloud.hisavana.protocol.okhttptransport.RedirectStrategy;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.Source;
import okio.Timeout;
import org.chromium.net.CronetException;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;

class OkHttpBridgeRequestCallback
extends UrlRequest.Callback {
    private static final int CRONET_BYTE_BUFFER_CAPACITY = 32768;
    private final SettableFuture<Source> bodySourceFuture = SettableFuture.create();
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private final BlockingQueue<CallbackResult> callbackResults = new ArrayBlockingQueue<CallbackResult>(2);
    private final SettableFuture<UrlResponseInfo> headersFuture = SettableFuture.create();
    private final long readTimeoutMillis;
    private final List<UrlResponseInfo> urlResponseInfoChain = new ArrayList<UrlResponseInfo>();
    private final RedirectStrategy redirectStrategy;
    private volatile UrlRequest request;

    OkHttpBridgeRequestCallback(long readTimeoutMillis, RedirectStrategy redirectStrategy) {
        Preconditions.checkArgument((readTimeoutMillis >= 0L ? 1 : 0) != 0);
        this.readTimeoutMillis = readTimeoutMillis == 0L ? Integer.MAX_VALUE : readTimeoutMillis;
        this.redirectStrategy = redirectStrategy;
    }

    ListenableFuture<UrlResponseInfo> getUrlResponseInfo() {
        return this.headersFuture;
    }

    ListenableFuture<Source> getBodySource() {
        return this.bodySourceFuture;
    }

    List<UrlResponseInfo> getUrlResponseInfoChain() {
        return Collections.unmodifiableList(this.urlResponseInfoChain);
    }

    public void onRedirectReceived(UrlRequest urlRequest, UrlResponseInfo urlResponseInfo, String nextUrl) {
        if (!this.redirectStrategy.followRedirects()) {
            Preconditions.checkState((boolean)this.headersFuture.set((Object)urlResponseInfo));
            Preconditions.checkState((boolean)this.bodySourceFuture.set((Object)new Buffer()));
            urlRequest.cancel();
            return;
        }
        this.urlResponseInfoChain.add(urlResponseInfo);
        if (urlResponseInfo.getUrlChain().size() <= this.redirectStrategy.numberOfRedirectsToFollow()) {
            urlRequest.followRedirect();
            return;
        }
        urlRequest.cancel();
        ProtocolException e = new ProtocolException("Too many follow-up requests: " + (this.redirectStrategy.numberOfRedirectsToFollow() + 1));
        this.headersFuture.setException((Throwable)e);
        this.bodySourceFuture.setException((Throwable)e);
    }

    public void onResponseStarted(UrlRequest urlRequest, UrlResponseInfo urlResponseInfo) {
        this.request = urlRequest;
        Preconditions.checkState((boolean)this.headersFuture.set((Object)urlResponseInfo));
        Preconditions.checkState((boolean)this.bodySourceFuture.set((Object)new CronetBodySource()));
    }

    public void onReadCompleted(UrlRequest urlRequest, UrlResponseInfo urlResponseInfo, ByteBuffer byteBuffer) {
        this.callbackResults.add(new CallbackResult(CallbackStep.ON_READ_COMPLETED, byteBuffer, null));
    }

    public void onSucceeded(UrlRequest urlRequest, UrlResponseInfo urlResponseInfo) {
        this.callbackResults.add(new CallbackResult(CallbackStep.ON_SUCCESS, null, null));
    }

    public void onFailed(UrlRequest urlRequest, UrlResponseInfo urlResponseInfo, CronetException e) {
        if (this.headersFuture.setException((Throwable)e) && this.bodySourceFuture.setException((Throwable)e)) {
            return;
        }
        this.callbackResults.add(new CallbackResult(CallbackStep.ON_FAILED, null, e));
    }

    public void onCanceled(UrlRequest urlRequest, UrlResponseInfo responseInfo) {
        this.canceled.set(true);
        this.callbackResults.add(new CallbackResult(CallbackStep.ON_CANCELED, null, null));
        IOException e = new IOException("The request was canceled!");
        this.headersFuture.setException((Throwable)e);
        this.bodySourceFuture.setException((Throwable)e);
    }

    private static enum CallbackStep {
        ON_READ_COMPLETED,
        ON_SUCCESS,
        ON_FAILED,
        ON_CANCELED;

    }

    private static class CallbackResult {
        private final CallbackStep callbackStep;
        @Nullable
        private final ByteBuffer buffer;
        @Nullable
        private final CronetException exception;

        private CallbackResult(CallbackStep callbackStep, @Nullable ByteBuffer buffer, @Nullable CronetException exception) {
            this.callbackStep = callbackStep;
            this.buffer = buffer;
            this.exception = exception;
        }
    }

    private class CronetBodySource
    implements Source {
        private ByteBuffer buffer = ByteBuffer.allocateDirect(32768);
        private volatile boolean closed = false;

        private CronetBodySource() {
        }

        public long read(Buffer sink, long byteCount) throws IOException {
            CallbackResult result;
            if (OkHttpBridgeRequestCallback.this.canceled.get()) {
                throw new IOException("The request was canceled!");
            }
            Preconditions.checkArgument((sink != null ? 1 : 0) != 0, (Object)"sink == null");
            Preconditions.checkArgument((byteCount >= 0L ? 1 : 0) != 0, (String)"byteCount < 0: %s", (long)byteCount);
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
            if (OkHttpBridgeRequestCallback.this.finished.get()) {
                return -1L;
            }
            if (byteCount < (long)this.buffer.limit()) {
                this.buffer.limit((int)byteCount);
            }
            OkHttpBridgeRequestCallback.this.request.read(this.buffer);
            try {
                result = (CallbackResult)OkHttpBridgeRequestCallback.this.callbackResults.poll(OkHttpBridgeRequestCallback.this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                result = null;
            }
            if (result == null) {
                OkHttpBridgeRequestCallback.this.request.cancel();
                throw new CronetTimeoutException();
            }
            switch (result.callbackStep) {
                case ON_FAILED: {
                    OkHttpBridgeRequestCallback.this.finished.set(true);
                    this.buffer = null;
                    throw new IOException((Throwable)result.exception);
                }
                case ON_SUCCESS: {
                    OkHttpBridgeRequestCallback.this.finished.set(true);
                    this.buffer = null;
                    return -1L;
                }
                case ON_CANCELED: {
                    this.buffer = null;
                    throw new IOException("The request was canceled!");
                }
                case ON_READ_COMPLETED: {
                    result.buffer.flip();
                    int bytesWritten = sink.write(result.buffer);
                    result.buffer.clear();
                    return bytesWritten;
                }
            }
            throw new AssertionError((Object)"The switch block above is exhaustive!");
        }

        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!OkHttpBridgeRequestCallback.this.finished.get()) {
                OkHttpBridgeRequestCallback.this.request.cancel();
            }
        }
    }
}

